/**
 * @author priyanshi sharma
 * 
 */
var statementFor = Ext.create('Ext.data.Store', {
	fields: ['value', 'name'],
	data : [
		{"value":"CURRENT_MONTH", "name":"Current month"},
		{"value":"LAST_MONTH", "name":"Last Month"},
		{"value":"THREE_MONTH", "name":"3 Months"},
		{"value":"SIX_MONTH", "name":"6 Months"},
		{"value":"YEARLY", "name":"Yearly"}]
});
Ext.define('Academia.view.receipt.receiptsettings.StatementEmailSettingForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.statementemailsettingform',
    style:{
		'padding':'32px !important'
	},
    items: [{
    	xtype:'form',
    	frame: true,
    	method: 'POST',
    	defaults: {
            layout : 'vbox',
        },
    	standardSubmit: false,
    	plugins : "formlabelrequired",
    	items: [{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		defaults: {
    			labelAlign: 'top',
    			width: 256
    		},
    		items:[{
    			xtype: 'customcombobox',
    			name:'statementFor',
    			itemId:'statementFor',
    			allowBlank:false,
    			store:statementFor,
    			valueField: 'value',
	        	displayField: 'name', 
	        	editable: false,
	        	querymode: 'local',
	        	value:'LAST_MONTH',
    			fieldLabel: getFeeAndPaymentCommonTranslation('STATEMENT_FOR')
    		}]
    	},{
    		xtype: 'container',  
    		width: '100%',
    		itemId: 'langTemplateMappingContainerId',
    		style:{
    	        marginTop:'20px !important'
    	   },
    		items:[{
    			xtype: 'fieldcontainer',
    			itemId: 'langTemplateMappingFieldContainerId',
    			layout: {
    				type: 'hbox'
    			},
    			defaults: {
    				labelAlign: 'top',
    				allowBlank:false
    			},
    			items:[{
    				xtype: 'customcombobox',
    				width: 256,
    				name:'language',
    				itemId:'languageItemId',
    				editable: false,
    				store:'common.MultiLanguageCorrespondenceLangStore',
    				valueField: 'id',
    	        	displayField: 'value', 
    	        	editable: false,
    				fieldLabel: getFeeAndPaymentCommonTranslation('LANGUAGE')
    			},{
    				xtype: 'customcombobox',
    				width: 256,
    				name:'templateMapping',
    				itemId:'templateMappingItemId',
    				valueField: 'id',
    	        	displayField: 'value', 
    	        	store:'receipt.receiptsettings.StatementEmailTemplateMappingStore',
    				editable: false,
    				fieldLabel: getFeeAndPaymentCommonTranslation('TEMPLATE_MAPPING'),
    				listConfig: {
    	        		loadingText: getCommonTranslation('SEARCHING'),
    	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	        		listeners: {
    	        			beforeshow: function(picker) {
    	        				picker.width = picker.up('combobox').getSize().width;
    	        			}
    	        		},
    	        	}
    			},{
    				xtype: 'customcombobox',
    				width: 256,
    				name:'eventMapping',
    				itemId:'eventMappingItemId',
    				valueField: 'id',
    	        	displayField: 'code', 
    	        	store:'receipt.receiptsettings.StatementEmailEventMappingStore',
    	        	editable: false,
    				fieldLabel: getFeeAndPaymentCommonTranslation('EVENT_MAPPING'),
    				listConfig: {
    	        		loadingText: getCommonTranslation('SEARCHING'),
    	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    	        		listeners: {
    	        			beforeshow: function(picker) {
    	        				picker.width = picker.up('combobox').getSize().width;
    	        			}
    	        		},
    	        	},
    	        	listeners: {
	        			render: function(combo) {
							var store= combo.getStore();
							store.getProxy().extraParams = {
								msgRecipientCode : 'STUDENT_ACCOUNT_STATEMENT'
							};
							store.load();
						}
	        		}
    			},{
    				xtype: 'checkboxfield',
    				labelAlign: 'right',
    				cls:'emailSettingFormCls',
    				name:'markAsDefault',
    				itemId:'markAsDefaultItemId',
    				style:{margin:'24px'},
    				value:true,
    				boxLabel: getFeeAndPaymentCommonTranslation('MARK_AS_DEFAULT'),
    				inputValue : true
    			},{
    				xtype: 'button',
    				itemId: 'addMoreRowsBtnId',
    				cls: 'CustomBodyBtnSettings',
    				style:{marginTop:'28px'},
    				text: getCommonTranslation('ADDBUTTONTEXT'),
    				tooltip: getCommonTranslation('ADD'),
    			}]
    		}]
    	},{
    		xtype: 'checkboxfield',
    		labelAlign: 'right',
    		name:'correspondenceLang',
    		itemId:'correspondenceLang',
    		boxLabel: getFeeAndPaymentCommonTranslation('COMMUNICATION_AS_PER_STUDENT_CORRESPONDENCE_LANGUAGE'),
    		inputValue : true,
    		cls:'emailSettingFormCls'
    	},{
    		xtype:'fieldcontainer',
    		width : 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		items: [{
    			xtype: 'button',
    			text: getFeeAndPaymentCommonTranslation('SAVE'),
    			formBind: true,
    			itemId: 'SubmitBtn',
    			ui: 'CustomBtnSubmit',
    			scale: CONSTANTS.BUTTONSIZE
    		},{
    			xtype: 'button',
    			text: getFeeAndPaymentCommonTranslation('RESET'),
    			itemId: 'resetBtn',
    			ui: 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE
    		}]
    	}]
    },{
    	xtype:'statementemailsettinggrid',
    	itemId:'statementemailsettinggrid',
    }]
});