/**
 * @author Manisha Wagh
 */
Ext.define('Academia.view.receipt.receiptsettings.ViewBankChangesSettingsWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.viewbankchangessettingswin',
    title: getFeeAndPaymentCommonTranslation('BANK_CHARGES_SETTINGS'),
    width:550,
    height:300,
    modal: true,
    autoScroll: false,
    items: [{
        xtype: 'form',
        itemId: 'viewBankChargesSettingsWinFormItemId',
        method: 'POST',
        defaults: {
            labelAlign: 'top',
        },
        standardSubmit: false,
        plugins: "formlabelrequired",
        items: [{
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'hidden',
                name: 'id'
            }, {
				xtype: 'customcombobox',
				name: 'feePaymentModes',
				itemId:'feePaymentModes',
				fieldLabel: getFeeAndPaymentCommonTranslation('FEE_PAYMENT_MODES'),
				store: 'feeandpayment.FeePaymentModeForReceiptStore',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true,
				autoloadStore: false,
				readOnly : true,
			},{
				xtype: 'customcombobox',
				name: 'bankDrawnOnMaster',
				itemId:'bankDrawnOnMaster',
				fieldLabel: getFeeAndPaymentCommonTranslation('BANK_DRAWN_ON_MASTER'),
				store: 'feeandpayment.receipts.DrawnOnBank',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				typeAhead:true,
				forceSelection:true,
				autoloadStore: false,
				readOnly : true,
			
			}]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
	     	    
				xtype: 'datefield',
				name: 'fromDate',
				itemId:'fromDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//minValue : Ext.Date.add(new Date(), Ext.Date.DAY, 1),
				editable:false,
				allowBlank: false,
				readOnly : true,
			},{
				xtype: 'datefield',
				name: 'toDate',
				itemId:'toDate',
				fieldLabel: getFeeAndPaymentCommonTranslation('TO_DATE'),
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				/*vtype : 'daterange',
				startDateField : 'fromDate',*/
			//	minValue:'fromDate',
				editable:false,
				allowBlank: false,
				readOnly : true,
			}]
        }, {
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			
				items:[{
					xtype : 'numberfield',
					itemId:'bankChargesApplicable',
					name: 'bankChargesApplicable',
					labelAlign : 'top',
					/*minValue : 0,
					maxValue : 100,*/
					decimalPrecision: 2,
					maxLength: 5,
					minValue: 0,
					allowExponential: false,
					allowDecimals: true,
					allowBlank: false,
					hideTrigger:true,
					fieldLabel:getFeeAndPaymentCommonTranslation('BANK_CHARGES_APPLICABLE'),
					readOnly : true,
				},{
					xtype : 'numberfield',
					itemId:'thresholdLimitItemId',
					name: 'thresholdLimit',
					decimalPrecision: 2,
					maxLength: 10,
					minValue: 1,
					allowExponential: false,
					allowDecimals: true,
					labelAlign : 'top',				
					allowBlank: true,
					hideTrigger:true,
					fieldLabel:getCommonTranslation('THRESHOLD_LIMIT'),
				}]
		},{
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'btnCancelViewBankChargesSettingsItemId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});