/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.registrationsetup.LateFeeConfigForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.latefeeconfigform',
    plugins : "formlabelrequired",
    frame : false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype:'hidden',
            	name:'record',
            	itemId:'recordId'
            },{
            	xtype:'hidden',
            	name:'termwiseCourseRegistration',
            	itemId:'termwiseCourseRegistrationId'
            },{
            	xtype:'hidden',
            	name:'configureLinkRowIndex',
            	itemId:'configureLinkRowIndex'
            },{
                xtype: 'customcombobox',
                name: 'feePlanType',
                itemId: 'feePlanTypeId',
                store:'registrationsetup.FeePlanTypeStoreForRegistration',
                fieldLabel: getCommonTranslation('FEE_PLAN_TYPE'),
                value:'Program',
                displayField: 'value',
                valueField: 'id',
                readOnly:true,
                allowBlank:false
    	     },{
                xtype: 'customcombobox',
                name: 'feePlanName',
                itemId: 'feePlanNameId',
                fieldLabel: getCommonTranslation('FEE_PLAN_NAME'),
                store:'registrationsetup.FeePlanNameStoreForRegistration',
                displayField: 'value',
                valueField: 'id',
                allowBlank:false
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'stage',
                itemId: 'stageId',
                fieldLabel: getCommonTranslation('FEE_PLAN_STAGE'),
                store:'registrationsetup.FeePlanStageStoreForRegistration',
                value:'Course Execution',
                readOnly:true,
                displayField: 'value',
                valueField: 'id',
                allowBlank:false
    	     },{
                xtype: 'customcombobox',
                name: 'feePlanRule',
                itemId: 'feePlanRuleId',
                fieldLabel: getCommonTranslation('FEE_PLAN_RULE'),
                store:'registrationsetup.FeePlanRuleStoreForRegistration',
                displayField: 'value',
                valueField: 'id',
                allowBlank:false
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'textfield',
                name: 'amountToBePaid',
                itemId: 'amountToBePaidId',
                fieldLabel: getCommonTranslation('AMOUNT_TO_BE_PAID'),
    	     },{
                xtype: 'customcombobox',
                name: 'status',
                itemId: 'statusId',
                fieldLabel: getCommonTranslation('STATUS'),
                store:Ext.create('Academia.store.common.StatusComboStore'),
                displayField: 'name',
                valueField: 'value',
                allowBlank:false,
                value:'Active'
            }]
        },{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'submitLateFeeConfig',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'cancelLateFeeConfig',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
});