/**
 * @author Pravin.Surve
 * this grid to to show quota violation report
 */
Ext.define('Academia.view.reports.admission.QuotaViolationReportGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.quotaviolationreportgrid',
    title: getAdmissionTranslation('QUOTA_VIOLATION_REPORT'),
    border: true,
    autoScroll: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    columns: [{
        header: getAdmissionTranslation('QUOTA'),
        dataIndex: 'quota',
        sortable:true,
        flex: 1
    },{
        header: getAdmissionTranslation('QUOTA_TYPE'),
        dataIndex: 'quotaType',
        sortable:true,
        flex: 1
    },{
        header: getAdmissionTranslation('NO_OF_VIOLATION'),
        dataIndex: 'noOfViolation',
        sortable:true,
        flex: 1
    }],
    
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.reports.admission.QuotaViolationGridStore');
    }

});