/**
 * This view is used for Admission Demographics Search Form
 * 
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.admissionDemographics.AdmissionDemographicsSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.admissiondemographicssearchform',
 //   titleCollapse : true,
    cls:'customSearchPanel',
    items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			allowBlank : false,
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:'common.AcademyLocationNameSeparated',
			cls:'multiBrandCampusCls',
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
			}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYearId',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
//			width: 256,
			typeAhead:true,
			editable: false,
			forceSelection:true,
			minChars:3,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
        xtype: 'fieldcontainer',
        itemId: 'admissionDemographicsProgrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'programId',
            itemId: 'programIds',
            fieldLabel: getCommonTranslation('PROGRAM'),
//            translationKey : 'PROGRAM',
            displayField: 'value',
            autoloadStore: false,
            queryMode: 'local',
           // editable: false,
            valueField: 'id',
            store: 'common.ProgramsByAcademyIdLocationId'
        }, {
            xtype: 'multiselectcombofield',
            name: 'batchId',
            itemId: 'batchIds',
            //editable: false,
            autoloadStore: false,
            queryMode: 'local',
            disabled: true,
            fieldLabel: getCommonTranslation('BATCH'),
            displayField: 'value',
            valueField: 'id',
            store: 'common.BatchesByProgramId'
        }, {
	        xtype: 'multiselectcombofield',
	        fieldLabel: getCommonTranslation('SEAT_TYPE'),
	        //editable: false,
	        autoloadStore: false,
	        queryMode: 'local',
	        disabled: true,
	        name: 'seatTypeId',
	        itemId: 'seatTypeIds',
	        valueField: 'id',                
	        displayField: 'value',
	        store: 'admission.admissionCommon.SeatTypesByBatchIdsStore'
    }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'checkboxFieldContainer',
        width: '100%',
        layout: {
            type: 'hbox'
        },
        defaultType: 'checkboxfield',
        items: [{                
            boxLabel: getAdmissionTranslation('SELECT_COUNTRY'),
            name: 'SELECT_COUNTRY',
            itemId:'selectCountry',
            inputValue: true,
            uncheckedValue: false
        },{                
            boxLabel: getAdmissionTranslation('SELECT_RELIGION'),
            name: 'SELECT_RELIGION',
            itemId:'selectReligion',
            inputValue: true,
            uncheckedValue: false
        },{                
            boxLabel: getAdmissionTranslation('DEFINE_AGE_RANGE'),
            name: 'DEFINE_AGE_RANGE',
            itemId:'ageRange',
            inputValue: true,
            uncheckedValue: false
        },{                
            boxLabel: getAdmissionTranslation('DEFINE_INCOME_RANCE'),
            name: 'DEFINE_INCOME_RANCE',
            itemId:'incomeRange',
            inputValue: true,
            uncheckedValue: false
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'admissionDemographicsMutiselect',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'multiselectcombofield2',
            name: 'countryId',
            itemId: 'countryId',
            height:20,
            store: 'Academia.store.common.CountryStore',
            fieldLabel: getAdmissionTranslation('COUNTRY'),
            //value : 'All',
            hidden : true,
            displayField: 'countryName',
            valueField: 'id'
        }, {
            xtype: 'multiselectcombofield',
            name: 'religionId',
            itemId: 'religionId',
            hidden : true,
            store: 'Academia.store.common.ReligionStore',
            fieldLabel: getAdmissionTranslation('RELIGION'),
            displayField: 'value',
            //value : 'All',
            valueField: 'id'
        }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'admissionDemographicsTextField',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            itemId: 'ageRangeGreater',
            hidden : true,
            fieldLabel: getAdmissionTranslation('AGE_RANGE_GREATER_THAN'),
            name: 'greaterThanAge'
        },{
            xtype: 'textfield',
            itemId: 'ageRangeLess',
            hidden : true,
            fieldLabel: getAdmissionTranslation('AGE_RANGE_LESS_THAN'),
            name: 'lessThanAge'
        },{
            xtype: 'textfield',
            itemId: 'incomeRangeGreater',
            hidden : true,
            fieldLabel: getAdmissionTranslation('INCOME_RANGE_GREATER_THAN'),
            name: 'greaterThanIncome'
        },{
            xtype: 'textfield',
            itemId: 'incomeRangeLess',
            hidden : true,
            fieldLabel: getAdmissionTranslation('INCOME_RANGE_LESS_THAN'),
            name: 'lessThanIncome'
        }]
    },{
        xtype: 'fieldcontainer',
        layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'admissionDemographicsSearchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'admissionDemographicsResetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});