/**
 * This view is used for Admission Demographics Search Form
 * 
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.admissionDemographics.AdmissionDemographicsWithBreakup', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissiondemographicswithbreakup',
    title: getAdmissionTranslation('ADMISSION_WITH_BREAKUP'),
    frame: false,
    cls: 'x-form-fixed-footer-parent',
	items:[{
    	xtype: 'fieldcontainer',
    	itemId: 'showBreakupFieldContainerId',
    	layout: 'hbox',
    	items: [/*{
        	xtype:'displayfield',
        	width: 200,
        	labelWidth:80,
        	fieldLabel: getAdmissionTranslation('TOTAL_INTAKE'),
        	name: 'totalIntakeWith',
        	itemId: 'totalIntakeWithId',
        	value: '3500',
        	fieldStyle:{
            	marginTop: '4px !important'
            }
        },*/{
            xtype: 'customcombobox',
            width: 340,
            labelWidth:150,
            name: 'acadLocId',
            itemId: 'acadLocId',
            fieldLabel: getAdmissionTranslation('SHOW_BREAKUP_FOR'),
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.admission.AdmissionDemographicsAcadLocStore');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            width: 275,
            labelWidth:75,
            name: 'academyId',
            hidden: true,
            itemId: 'academyId',
            fieldLabel: getAdmissionTranslation('ACADEMY'),
            displayField: 'value',
            autoLoad: false,
            valueField: 'id',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.admission.AdmissionDemographicsAcademyStore');
                    combo.bindStore(store);
                }
            }
        },{
            xtype: 'customcombobox',
            width: 275,
            labelWidth:75,
            name: 'locationId',
            hidden: true,
            autoLoad: false,
            itemId: 'locationId',
            fieldLabel: getAdmissionTranslation('LOCATION'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.reports.admission.AdmissionDemographicsLocationStore');
                    combo.bindStore(store);
                }
            }
        }]
    },{
    	xtype: 'panel',
    	itemId : 'admissionDemographicsWithBreakupPanel',
    	items : [{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	width: 1350,
            minHeight: 350,
        	items: [{
        		xtype: 'panel',
        		itemId : 'maleFemaleWithChartPanel',
        		layout:'vbox',
        		items: [{
        			xtype: 'label',
        			width : 350,
                    text: getAdmissionTranslation('MALE_FEMALE_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    itemId: 'maleFemaleWithChart',
                    width : 350,
                    minHeight : 300,
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	}, {
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'bloodGroupWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('BLOOD_GROUP_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'bloodGroupWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'marriedUnmarriedWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('MARRIED_UNMARRIED_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'marriedUnmarriedWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	}]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	width: 1350,
            minHeight: 350,
        	items: [/*{
            	xtype:'displayfield',
            	name: 'academyLocation',
            	width: 130,
            	itemId: 'academyLocationName',
            	value: 'Pravin Surve e-Zest Solution Ltd pune'
            },*/{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'religionWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('RELIGION_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'religionWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'countryWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
                    text: getAdmissionTranslation('COUNTRIES_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    itemId: 'countryWithChart',
                    width : 350,
                    minHeight : 300,
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	}, {
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'categoriesWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('CATEGORIES_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'categoriesWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	}]
        },{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	width: 1350,
            minHeight: 350,
        	items: [{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'ageRangeWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('AGE_RANGE_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'ageRangeWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'incomeRangeWithChartPanel',
        		items: [{
        			xtype: 'label',
        			width : 350,
        			text: getAdmissionTranslation('INCOME_RANGE_CHART'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 350,
                    minHeight : 300,
                    itemId: 'incomeRangeWithChart',
                    store: 'Academia.store.reports.admission.AdmissionDemographicsStore',
                    numericField: 'count',
                    categoryField: 'name'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'incomeRangeChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'incomeRangeChartField',
	            	value : 'No data to display',
	            	hidden: true
	            }]
        	}]
        }]
    }]

});
