/**
 * This view is used for application statistics view 
 * @author Harsh.Nagra
 */

Ext.define('Academia.view.reports.admission.dashboard.ApplicationStatisticsView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.applicationstatisticsview',
    autoScroll: false,
	frame: false,
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
    	xtype: 'form',
    	cls:'customSearchPanel',
    	plugins: "formlabelrequired",
        itemId: 'applicationStatisticsSearchForm',
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'admissionStaticsAcademyYearContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'customcombobox',
            	name: 'applicationStatistics',
            	labelWidth : 170,
            	labelAlign: 'top',
            	fieldLabel: getAdmissionTranslation('SHOW_STATISTICS_FOR'),
            	itemId: 'applicationStatistics',
            	displayField: 'name',
            	valueField: 'value',
            	allowBlank: false,
            	queryMode: 'local',
            	editable: false,
            	listeners: {
            		render: function(combo) {
            			var store = Ext.create('Academia.store.reports.admission.ApplicationStatisticReportStore');
            			combo.bindStore(store);
            		}
            	}
            },{
            	xtype: 'customcombobox',
            	fieldLabel: getPersonModuleTranslation('NAME_OF_EXAM'),
            	valueField: 'id',
            	displayField: 'value',
            	//store: Ext.create('Academia.store.admission.applications.history.ExaminationName'),
            	name: 'nameOfExam',
            	itemId: 'nameOfExam',
            	allowBlank:false,
            	editable: false,
            	hidden : true,
            	forceSelection:true,
            	listeners: {
            		render: function(combo) {
            			var store = Ext.create('Academia.store.admission.applications.history.ExaminationName');
            			combo.bindStore(store);
            		}
            	}
            },{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('INTAKE_YEAR'),
            	name : 'intakeYear',
            	itemId : 'intakeYear',
            	displayField:'value',
            	valueField:'id',
            	width: 256,
            	typeAhead:true,
            	forceSelection:true,
            	minChars:3,
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  +
            			'</div>';
            		}
            	},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.IntakeYearStore');
            			combo.bindStore(store)
            		}
            	}
            },{
            	xtype : 'customcombobox',
            	fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
            	name : 'academicTerm',
            	itemId : 'academicTerm',
            	displayField : 'value',
            	valueField : 'id',
            	typeAhead : true,
            	forceSelection : true,
            	hidden : false,
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.AcademicTermStore');
            			combo.bindStore(store)
            		}
            	}
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
    		itemId: 'applicationStaticsDateContainer',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
            	xtype: 'datefield',
            	fieldLabel: getAdmissionTranslation('START_DATE'),
            	name: 'startDate',
            	itemId :'startDate',
            	vtype: 'daterange',
            	endDateField: 'endDate',
            	listeners: {
            		render: function(field) {
            			return dateFormatRender(field);
            		}
            	}
            },{
            	xtype: 'datefield',
            	fieldLabel: getAdmissionTranslation('END_DATE'),
            	name: 'endDate',
            	itemId: 'endDate',
            	vtype: 'daterange',
            	startDateField: 'startDate',
            	listeners: {
            		render: function(field) {
            			return dateFormatRender(field);
            		}
            	}
            },{
				xtype : 'multiselectcombofield',
				cls:'commonAutoHeightMultiselectField',
				fieldLabel: getCommonTranslation('SEAT_TYPE'),
				name: 'seatType',
				itemId:'seatType',
				displayField: 'value',
				valueField: 'id',
				typeAhead : true,
				forceSelection : true,
				editable: false,
	            disableKeyFilter: false,
	            store:Ext.create('Academia.store.common.AllSeatTypeListStore'),
	            listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code}'  + '{value}' +
            			'</div>';
            		}
            	}
			}]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
        	cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getAdmissionTranslation('SEARCH'),
                itemId: 'applicationStatisticsFindButtonId',
                buttonAlign: 'right',
                formBind: true,
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getAdmissionTranslation('CLEAR_SEARCH'),
                itemId: 'applicationStatisticsClearSearch',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]	
    }, {
    	xtype: 'tabpanel',
    	layout: 'hbox',
    	plain: true,
        border: false,
        autoScroll: false,
        style:{overflow:'hidden !important',margin:'0!important'},
        items: [{
        	title: getAdmissionTranslation('DATA'),
        	xtype: 'panel',
        	items: [{
        		xtype:'applicationstaticsgrid',
        		itemId:'applicationstaticsgrid'
        	}]
        },{
    		title: getAdmissionTranslation('CHART'),
    		xtype: 'panel',
    		itemId: 'applicantStaticsticsPanel',
    		items: [{
    			xtype:'fieldcontainer',
    			itemId: 'applicantStaticsticsfieldcontainer',
    			items:[{
    				xtype: 'button',
    				itemId: 'academyExtraBtns',
    				hidden:true,
    				cls:'CustomToolbarBtnExport',
    				iconCls:'export-image-icon',
    				style:{'float':'right'},
    				menu: []
    			}]
    		},{
                xtype: 'columnchartapplicationstatisticsreport',
                itemId: 'applicationShowStatisticsForPieChart',
                //autoScroll: true,
                hidden:true,
                minWidth:1000,
                height : 600,
                columnColor: 'orange',
                store: 'Academia.store.reports.admission.ApplicationStatisticsByAcademies',
                xAxesNumericField: 'count',
                yAxesCategoryField: 'name'
            },{
                xtype: 'barchartreport',
                itemId: 'applicationShowStatisticsForBarchartreport',
                //autoScroll: true,
                hidden:true,
                minWidth:1000,
                height : 600,
                columnColor: 'orange',
                store: 'Academia.store.reports.admission.ApplicationStatisticsByAcademies',
                xAxesNumericField: 'count',
                yAxesCategoryField: 'name'
            },{
            	xtype: 'displayfield',
            	itemId : 'incomeRangeChartField',
            	width : 300,
            	fieldStyle: {
            		marginTop : '70px',
            		marginLeft : '290px !important'
            	},
            	name: 'incomeRangeChartField',
            	value : 'No data to display'
            	//hidden: true
            }]
    	}]
    }]
});