/**
 * This view is used for Selection Process Overview View
 * @author Pravin.Surve
 */

Ext.define('Academia.view.reports.admission.dashboard.SelectionProcessOverviewView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.selectionprocessoverviewview',
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'selectionprocessoverviewsearchform',
        itemId: 'selectionProcessOverviewSearchForm'
    }, {
    	xtype: 'form',
    	itemId: 'selectionProcessForm',
    	frame: true,
    	layout:'vbox',
    	items:[{
    		xtype:'fieldcontainer',
			layout:'hbox',
			items:[{
				xtype: 'label',
				width : 700,
				text: getAdmissionTranslation('SELECTION_PROCESS'),
				style: {
					color : 'black',
					'text-align': 'center',
					'font-weight': 'bold',
					'font-size': '16px'
				}
			},{
				xtype: 'button',
				itemId: 'selectionProcessExtraBtns',
				hidden:true,
				cls:'CustomToolbarBtnExport',
				iconCls:'export-image-icon',
				style:{marginLeft:'-200px'},
				menu: []
			}]
    	},{
    		xtype: 'stackedbarchartreport',
            itemId: 'selectionProcessOverviewColumnChart',
            minWidth: 800,
            height: 500,
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.admission.SelectionProcessOverviewStore',
            xAxesNumericField: 'name',
            xAxesNumericTitle: getAdmissionTranslation('COUNT_OF_STUDENTS'),
            yAxesCategoryField: [getAdmissionTranslation('COUNT'), getAdmissionTranslation('WRITTEN_TEST_STAGE'), getAdmissionTranslation('GROUP_DISCUSSION_INTERVIEW'),getAdmissionTranslation('ADMISSION_COMMITTEE_EVALUATION')],
            yAxesCategoryTitle: ""
        }]
    }]
});