/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.reports.admission.dashboard.dtefModuleResults.DtefModuleResultsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.dtefModuleResultsGrid',
    title: getCommonTranslation('SEARCH_RESULTS_HEADER'),
    store: 'reports.admission.dtefModuleResults.DtefModuleResultsGridStore',
    cls: 'enqgridsummarycls',
    border: true,
    frame: false,
    selType: 'checkboxmodel',
    selModel: {
        multiSelect: true,
        mode: 'SIMPLE',
        checkOnly: false
    },
    isGridConfigurable: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'reports.admission.dtefModuleResults.DtefModuleResultsGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'sendToDTEFBtn',
        tooltip: getCommonTranslation('SEND_TO_DTEF'),
        text: getCommonTranslation('SEND_TO_DTEF'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academy',
        flex: 1
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'location',
        flex: 1
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1
    }, {
        header: getCommonTranslation('SEAT_TYPE'),
        dataIndex: 'seatTypeName',
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'programPeriodName',
        flex: 1
    }, {
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'wSCoursesModelExam',
        flex: 1,
        renderer: function (value) {
            var count = value.length;
            if (count != null && count > 0) {
                return '<a  href="#">' + count + '</a>';
            } else {
                return 0;
            }
        }
    }, {
        header: getCommonTranslation('PERIOD_RESULT'),
        dataIndex: 'periodStatus',
        flex: 1
    }, {
        header: getCommonTranslation('RESPONSE_STATUS'),
        dataIndex: 'responceStatus',
        flex: 1
    }, {
        header: getCommonTranslation('RESPONSE'),
        dataIndex: 'responce',
        flex: 1
    }, {
        header: getCommonTranslation('RESPONSE_DATE'),
        dataIndex: 'responceDate',
        flex: 1,
        renderer: function (date) {
            if (!isNullOrEmpty(date)) {
                return dateRender(date);
            } else {
                return null;
            }
        }
    }]
});