/**
 * This view is used for the pending complaints history quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.complaints.PendingComplaintsHistorySearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.pendingcomplaintshistorysearch',
    frame: false,
    plugins: "formlabelrequired",
    cls: 'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'complaintTypeId',
            itemId: 'complaintTypeField',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintTypes');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'complaintAgainst',
            itemId: 'complaintAgainstField',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_AGAINST'),
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintAgainsts');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'complaintBy',
            itemId: 'complaintByField',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_BY'),
            displayField: 'value',
            valueField: 'id',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintBy');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            itemId: 'startDate',
            name: 'startDate',
            fieldLabel: getServiceRequestTranslation('START_DATE'),
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId : 'endDate',
            vtype: 'daterange',
            fieldLabel: getServiceRequestTranslation('END_DATE'),
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }, {
            xtype: 'numberfield',
            fieldLabel: getServiceRequestTranslation('NO_OF_DAYS'),
            minValue : 0,
            name: 'dayLimit'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'resourceGroup',
            itemId: 'faciltyTypeField',
            fieldLabel: getServiceRequestTranslation('FACILITY_TYPE'),
            displayField: 'value',
            valueField: 'name',
            queryMode: 'local',
            autoload: false,
            editable: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceGroupStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'resourceTypeId',
            itemId: 'physicalTypeField',
            fieldLabel: getServiceRequestTranslation('PHYSICAL_FACILITY_TYPE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            editable: false,
            width: 256,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.facilitiesresources.resourcebooking.ResourceTypeStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'resourceId',
            itemId: 'facilityCodeField',
            fieldLabel: getServiceRequestTranslation('FACILITY_CODE'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            editable: false,
            width: 256,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.InternalResourceStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]

});