/**
 * This view is used for faculty count of request  
 * @author Pravin.Surve
 */

Ext.define('Academia.view.reports.faculty.FacultyCountRequestView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.facultycountrequestview',
    title: getServiceRequestTranslation('COUNT_OF_REQUEST'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
    	xtype: 'facultydashboardcommonsearchform',
        itemId: 'facultyCountOfRequestSearchForm'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'facultyCountOfRequestChart',
            width: 700,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.CountOfRequestStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('MONTHS')
        }]
    }]
});