/**
 * This view is used for request closure rate search form
 * 
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.faculty.FacultyDashboardCommonSearchForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.facultydashboardcommonsearchform',
	frame: true,
	plugins: "formlabelrequired",
    isMinWidthNotRequired: true,
    cls: 'customSearchPanel',
	items: [{
		xtype: 'requestsubrequesttypefieldcontainer',
		itemId: 'requestTypeFieldContainer',
		layout: 'hbox'
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'livesearchcombo',
			name: 'requesterId',
			fieldLabel: getPersonModuleTranslation('REQUESTER_NAME'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			itemId: 'requesterNameId' ,
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintPersons');
					store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
					combo.bindStore(store);
				}
			},
			displayTpl: new Ext.XTemplate('<tpl for="."between=" ">',
					'{[typeof values === "string" ? values : values["value"]]}' +
					'</tpl>'
			),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			}


		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
			queryMode:'local',
			editable: false,
			name: 'departmentId',
			itemId: 'departmentCombo',
			valueField: 'id',
			displayField: 'value',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore');
					combo.bindStore(store);
				}
			}
		}, {
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),

			editable: false,
			queryMode: 'local',
			name: 'subDepartmentId',
			itemId: 'subDepartmentCombo',
			valueField: 'id',
			displayField: 'name',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.department.SubDepartmentComboStore');
					combo.bindStore(store);
				}
			}
		}]
	}, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype: 'livesearchcombo',
			itemId: 'assigneeCombo',
			store: 'Academia.store.reports.servicerequest.SystemUsersByAcademyLocationIds',
			hidden: true,
			fieldLabel: getServiceRequestTranslation('ASSIGN_TO'),

			name: 'assigneeId'
		}, {
			xtype: 'datefield',
			itemId: 'startDate',
			fieldLabel: getServiceRequestTranslation('CLOSED_START_DATE'),
			name: 'startDate',
			vtype: 'daterange',
			endDateField: 'endDate',
			maxValue : new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable: false
		}, {
			xtype: 'datefield',
			name: 'endDate',
			itemId : 'endDate',
			fieldLabel: getServiceRequestTranslation('CLOSED_UP_END_DATE'),
			vtype: 'daterange',
			startDateField: 'startDate',
			maxValue : new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
			editable: false
		}, {
			xtype: 'numberfield',
			itemId: 'dayLimitField',
			hidden : true,
			disabled : true,
			fieldLabel: getServiceRequestTranslation('NO_OF_DAYS'),
			allowBlank: false,
			minValue : 0,
			name: 'dayLimit'
		}]
	}, {
		xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchButtonId',
			disabled : true,
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
		}, {
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetButtonId',
			//buttonAlign: 'right',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});