
Ext.define('Academia.view.reports.programcourse.creditbasedreport.CreditBasedGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.creditbasedgrid',
	store : 'reports.programcourse.creditbasedreport.CreditBasedGridStr',
	title: getProgramandcourseTranslation('CREDIT_EARNED_RESULT'),
	border: true,
	autoScroll: false,
	refreshStoreData:true,
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix: {
//		headerFix: true,
		portalIdsWithStructure: {
			'creditbasedreportsearchtab': 1
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
		      xtype: 'custompagingtoolbar',
	            plugins:['pagesize'],
			store : 'reports.programcourse.creditbasedreport.CreditBasedGridStr',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid,false);
        this.callParent(arguments);     
	},
	tbar : [{
		xtype : 'button',
		itemId : 'exportReportsId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('DOWNLOADREPORT'),
		disabled:true
		//formBind:true
	}],
	columns : [/*{
		hidden:true,
		dataIndex:'id'
	},*/{
		header :getProgramandcourseTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1,
		renderer: function (value) {
			if (!isNullOrEmpty(value)) {
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocation',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('TOTAL_COURSES_ENROLLED'),
		dataIndex : 'totalCourses',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_COURSES_PASSED'),
		dataIndex : 'batchCoursesPassed',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_CREDITS_OFFERED'),
		dataIndex : 'totalCredit',
		flex:1
	},{
		header : getCommonTranslation('TOTAL_CREDITS_EARNED'),
		dataIndex : 'totalCreditsEarned',
		flex:1
	}]
});
