/**
 * @author Sachin.Bangar
 * This is used to show pop up for request assigned to person
 */
Ext.define('Academia.view.reports.servicerequest.RequestAssignedWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.requestassignedwindow',
    title: getServiceRequestTranslation('ASSIGN_REQUEST'),
    modal: true,
    width: 325,
    resizable: false,
    autoScroll: true,
    frame: true,
    items:[{
        xtype: 'form',
        itemId: 'assignRequestForm',
        items: [{
                xtype: 'fieldcontainer',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'customcombobox',
                    name: 'assigneeId',
                    itemId: 'requestAssigneeCombo',
                    fieldLabel: getServiceRequestTranslation('ASSIGN_TO'),
                    store: 'common.LiveSearchCombos', 
                    displayField: 'value', 
                    valueField: 'id', 
                    typeAhead: true,
                    hideTrigger:false,      
                    queryParam : 'term',
                    enableKeyEvents  : 'true',
                    minChars: 3, 
                    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
                    triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
                    remoteFilter: true,
                    displayTpl: new Ext.XTemplate(
                    		'<tpl for="."between=" ">',
                    		'{[typeof values === "string" ? values : values["firstName"]]} ' +
                    		'{[typeof values === "string" ? values : values["lastName"]]} ' + '[' +
                    		'{[typeof values === "string" ? values : values["code"]]}' + ']' +
                    		'</tpl>'
                    		),
                    		
                    listConfig :{
                    		  loadingText: getServiceRequestTranslation('SEARCHING'),
                    		  minWidth:256,
                    		  emptyText: getServiceRequestTranslation('NO_DATA_FOUND')
                    	}
                    
                }]
        },{
            xtype: 'fieldcontainer',
            width: '100%',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SUBMIT'),
                itemId: 'submitButtonId',
                buttonAlign: 'right',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                itemId: 'cancelButtonId',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]

    }]
});