/**
 * This view is used for Service level search form
 * 
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.student.ServiceLevelSearch', {
    extend: 'Ext.form.Panel',
    alias: 'widget.servicelevelsearch',
    frame: false,
    cls:'customSearchPanel',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'requestsubrequesttypefieldcontainer',
        itemId: 'requestTypeFieldContainer',
        layout: 'hbox'
    }, {
        xtype: 'fieldcontainer',
        itemId: 'progrmBatchSectionContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programComboField',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            
            displayField: 'valueCode',
            valueField: 'id',
           // queryMode: 'local',
            queryParam:'qry',
          //  autoload: false,
            allowBlank: true,
            minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            }, listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'+
                    '</div>';
                    }
                    }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchComboField',
            fieldLabel: getCommonTranslation('BATCH'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'sectionId',
            itemId: 'sectionComboField',
            fieldLabel: getCommonTranslation('SECTION'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 256,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getServiceRequestTranslation('NO_OF_DAYS'),
            
            allowBlank: false,
            minValue : 0,
            name: 'dayLimit'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});