/**
 * This view is used for Student exits in student dashboard
 * @author Pritam.Patil
 */
Ext.define('Academia.view.reports.student.personaldetail.StudentExitView', {
	extend:'Ext.form.FormPanel',
    alias: 'widget.studentexitview',
    title: getServiceRequestTranslation('STUDENT_EXITS'),
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'studentexitsearchform',
        itemId: 'studentExitSearchFormId'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
        	xtype: 'fieldcontainer',
        	layout: 'hbox',
        	width: 1000,
            minHeight: 300,
        	items: [{
        		xtype: 'panel',
        		hidden : true,
        		itemId : 'academyPanel',
        		layout:'vbox',
        		items: [{
        			xtype: 'label',
        			width : 300,
        			itemId : 'academyLabel',
                    text: getServiceRequestTranslation('BY_ACADEMIES'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    itemId: 'academiesChart',
                    width : 310,
                    minHeight : 300,
                    store: 'Academia.store.reports.student.ByAcademies',
                    numericField: 'count',
                    categoryField: 'property'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'academyChartField',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'academyChartField',
	            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
	            	hidden: true
	            }]
        	}, {
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'locationPanel',
        		hidden : true,
        		items: [{
        			xtype: 'label',
        			width : 300,
        			itemId : 'locationLabel',
        			text: getServiceRequestTranslation('BY_LOCATIONS'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 310,
                    minHeight : 300,
                    itemId: 'locationChart',
                    store: 'Academia.store.reports.student.ByLocations',
                    numericField: 'count',
                    categoryField: 'property'
                },{
	            	xtype: 'displayfield',
	            	itemId : 'locationChartFieldId',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'locationChartField',
	            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
	            	hidden: true
	            }]},{
            		xtype: 'panel',
            		layout:'vbox',
            		itemId : 'batchPanel',
            		hidden : true,
            		items: [{
            			xtype: 'label',
            			width : 300,
            			itemId : 'batchLabel',
            			text: getServiceRequestTranslation('BY_BATCH'),
            			style: {
            				color : 'black',
            				'text-align': 'center',
            				'font-weight': 'bold',
            				'font-size': '16px'
            			}
            		}, {
                        xtype: 'piechartreport',
                        width : 310,
                        minHeight : 300,
                        itemId: 'batchChart',
                        store: 'Academia.store.reports.student.ByBatches',
                        numericField: 'count',
                        categoryField: 'property'
                    },{
                    	xtype: 'displayfield',
    	            	itemId : 'bacthChartFieldId',
    	            	width : 350,
    	            	fieldStyle: {
    	            		marginTop : '70px',
    	            		marginLeft : '108px !important'
    	            	},
    	            	name: 'batchChartField',
    	            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
    	            	hidden: true
                    }]
            	}]
        	}, {
            	xtype: 'fieldcontainer',
            	layout: 'hbox',
            	width: 1000,
                minHeight: 300,
            	items: [{
        		xtype: 'panel',
        		layout:'vbox',
        		hidden :true,
        		itemId : 'sectionPanel',
        		items: [{
        			xtype: 'label',
        			itemId : 'sectionLabel',
        			width : 300,
        			text: getServiceRequestTranslation('BY_SECTION'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 310,
                    minHeight : 300,
                    itemId: 'sectionChart',
                    store: 'Academia.store.reports.student.BySections',
                    numericField: 'count',
                    categoryField: 'property'
                },{
                	xtype: 'displayfield',
	            	itemId : 'sectionChartFieldId',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'sectionChartField',
	            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
	            	hidden: true
                }]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'typeOfExitPanel',
        		hidden : true,
        		items: [{
        			xtype: 'label',
        			width : 300,
        			text: getServiceRequestTranslation('BY_TYPE_OF_EXIT'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
                    xtype: 'piechartreport',
                    width : 310,
                    minHeight : 300,
                    itemId: 'typeOfExitChart',
                    store: 'Academia.store.reports.student.ByTypeOfExits',
                    numericField: 'count',
                    categoryField: 'property'
                },{
                	xtype: 'displayfield',
	            	itemId : 'typeOfExitChartFieldId',
	            	width : 350,
	            	fieldStyle: {
	            		marginTop : '70px',
	            		marginLeft : '108px !important'
	            	},
	            	name: 'typeOfExitChartField',
	            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
	            	hidden: true
                }]
        	},{
        		xtype: 'panel',
        		layout:'vbox',
        		itemId : 'programsPanel',
        		hidden : true,
        		items: [{
        			xtype: 'label',
        			width : 300,
        			itemId : 'programLabel',
        			text: getServiceRequestTranslation('BY_PROGRAMS'),
        			style: {
        				color : 'black',
        				'text-align': 'center',
        				'font-weight': 'bold',
        				'font-size': '16px'
        			}
        		}, {
        			xtype: 'barchartreport',
                    itemId: 'admissionStatisticsByProgramBarChart',
                    minWidth: 700,
                    height: 500,
                    columnHeight: 30,
                    columnColor: 'orange',
                    store: 'Academia.store.reports.student.ByPrograms',
                    xAxesNumericField: 'count',
                    xAxesNumericTitle: getServiceRequestTranslation('COUNT_OF_PROGRAMS'),
                    yAxesCategoryField: 'property',
                    yAxesCategoryTitle: getServiceRequestTranslation('PROGRAMS')
            },{
            	xtype: 'displayfield',
            	itemId : 'programChartFieldId',
            	width : 350,
            	fieldStyle: {
            		marginTop : '70px',
            		marginLeft : '108px !important'
            	},
            	name: 'programChartField',
            	value : getServiceRequestTranslation('NO_RESULT_TO_DISPLAY'),
            	hidden: true
            }]
        	}]
    } ]}]
});