/**
 * This view is used for the inactive user report quick search form.
 * @author Rupesh.Agrawal
 */
Ext.define('Academia.view.reports.systemutilization.loginFrequency.LoginFrequencySearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.loginfrequencysearchform',
    autoScroll: false,
    frame: false,
    cls:'customSearchPanel',
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        style : {
        	marginLeft : '10px',
        	marginTop : '10px'
        },
        items: [{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
            fieldLabel: getCommonTranslation('FROM_DATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            endDateField : 'toDate',
	        vtype : 'daterange'
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
            fieldLabel: getCommonTranslation('TO_DATE'),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT,
	        startDateField : 'fromDate',
	        vtype : 'daterange'
		}]
     }, {
    	   xtype: 'fieldcontainer',
           width: '100%',
           layout: {
               type: 'hbox'
           },
           height:80,
           /*style:{
           	marginLeft:'10px'
           },*/
           items: [{
	        xtype: 'fieldcontainer',
	        fieldLabel : getCommonTranslation('USER_TYPE'),
	        labelAlign: 'top',
	        itemId: 'radioPanelUsers',
	        width: 'auto',
	        height:80,
	        style:{
            	marginLeft:'13px !important'
            },
	        layout: {
	            type: 'hbox'
	        },
	       items: [{
	            xtype: 'radiofield',
	            boxLabel: getCommonTranslation('INDIVISUAL'),
	            name: 'usrRadio',
	            inputValue: 'individual',
	            //width: 113,
	            itemId: 'individualRadioBtn'
	        }, {
	            xtype: 'radiofield',
	            boxLabel: getCommonTranslation('USER_GROUPS'),
	            name: 'usrRadio',
	            width: 120,
	            inputValue: 'userGroups',
	            itemId: 'userGroupRadioBtn'
	        }]
           },{
          	 xtype: 'fieldcontainer',
          	 fieldLabel : getCommonTranslation('LOGIN_FREQUENCY'),
          	 labelAlign: 'top',
             itemId: 'radioSummaryType',
             layout: {
                 type: 'hbox'
             },
             cls:'UserFrequencyradioBtnCls',
             //margin:'0 0 0 22',
             /*style:{
                	marginLeft:'22px !important'
                },*/
             items: [{
                 xtype: 'radiofield',
                 boxLabel: getCommonTranslation('DAILY'),
                 name: 'periodType',
                 inputValue: 'DAILY',
                 width: 113,
                 itemId: 'dailyRadioBtn'
             }, {
                 xtype: 'radiofield',
                 boxLabel: getCommonTranslation('MONTHLY'),
                 name: 'periodType',
                 inputValue: 'MONTHLY',
                 width: 113,
                 itemId: 'monthlyRadioBtn'
             }]}]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'userTypeIndividualFieldContainer',
        layout: 'hbox',
        disabled: true,
        hidden: true,
        defaults: {
        	xtype: 'multiselectcombofield',
        	valueField: 'id',
        	overridetSubmitData :true,
            width: 256,
            editable: true,
    		typeAhead: true,
            inputHeight: '30px',
//            height: '30px',
            labelAlign: 'top'
        },
        style:{
        	marginLeft:'10px'
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'userIds',
            itemId: 'frequency_user_id',
            autoloadStore: false,
            width: 536,
            fieldLabel: getCommonTranslation('USER_NAME'),
            store: 'criteriabuilder.userquicksearch.QuickSearchCode',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            queryParam: 'code',
            minChars: 3,
            typeAhead: true,
            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
            enableKeyEvents: 'true',
            hideTrigger: false,
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                    },
                    afterRender: function(combo) {
                        combo.getStore().on("load", function(store, items) {
                            if (items.length == 0)
                                Ext.select('.x-boundlist-item').elements[0].hidden = true;
                            else
                                Ext.select('.x-boundlist-item').elements[0].hidden = false;
                        });
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                        '{code}' +
                        '</div>';
                }
            }
      }/*{
            fieldLabel: getCommonTranslation('USER_ID'),
            name: 'userIds',
            itemId: 'frequency_user_id',
            store: 'systemusage.UserNames',
            displayField: 'code',
            overridetSubmitData: 'true',
            queryMode: 'local'
        }, {
            fieldLabel: getCommonTranslation('USER_NAME'),
            name: 'userIds',
            itemId: 'frequency_user_name',
            store: 'systemusage.UsersNameStore',
            displayField: 'value',
            autoloadStore: false,
            queryMode: 'local'
        }*/]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'userGroupFieldContainer',
        layout: 'hbox',
        disabled: true,
        hidden: true,
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        style:{
        	marginLeft:'10px'
        },
        items: [{
            xtype: 'multiselectcombofield',
            name: 'userGroupIds',
            fieldLabel: getCommonTranslation('USER_GROUP'),
            store: 'systemusage.UserGroupStore',
            displayField: 'userGroupName',
            valueField: 'id',
            overridetSubmitData :true,
            //inputHeight: '30px',
            //height: '30px',
            editable: false,
            queryMode: 'local',
    		typeAhead: true,
            itemId: 'frequency_user_group'
        }]
    }, {
        xtype: 'fieldcontainer',
       // width: '100%',
		layout :'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
            //formBind : true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'clearBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
            //formBind : true
        }]
    }]
});