/**
 * Ankur Jaiswal
 */
Ext.define('Academia.view.reports.userroleprivilege.URPFilter', {
	extend : 'Ext.form.Panel',
	alias : 'widget.urpfilter',
	autoScroll : false,
	frame : false,
	cls : 'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	items : [ {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PORTAL'),
			name : 'portalId',
			itemId : 'portalItemId',
			store : 'reports.userroleprivilege.URPPortalStore',
			valueField : 'id',
			displayField : 'portalName',
			allowBlank : false,
			editable : false,
			forceSelection : true,
		}, {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('MODULE'),
			name : 'module',
			itemId : 'moduleItemId',
			store : 'reports.userroleprivilege.URPModuleStore',
			valueField : 'id',
			displayField : 'moduleName',
			disabled : true,
			allowBlank : false,
			editable : false,
			forceSelection : true,
		} ]
	}, {
		xtype : 'fieldcontainer',
       // width: 'auto',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [ {
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('FEATURE'),
			name : 'featureId',
			itemId : 'featureItemId',
			store : 'reports.userroleprivilege.URPFeatureStore',
			valueField : 'id',
			displayField : 'value',
			disabled : true,
			editable : false,
			forceSelection : true,
            padding: '10px 0 0 0'
		}, {
			xtype : 'multiselectcombofield',
			queryMode : 'local',
			fieldLabel : getCommonTranslation('PRIVILEGE'),
			name : 'privilegeId',
			itemId : 'privilegeItemId',
			store : 'reports.userroleprivilege.URPPrivilegeStore',
			valueField : 'id',
			displayField : 'value',
			disabled : true,
			cls:'multiBrandCampusCls',
			allowBlank : false,
			padding: '10px 0 0 0',
			//editable: false,
			listConfig: {		    	
				listeners: {
					beforeshow: function(picker) {
						var combobox = picker.up('combobox');		    			
						picker.minWidth = combobox.getSize().width;
						picker.width = 'auto';
						setTimeout(function(){
							picker.el.dom.style.width='auto';
							picker.el.dom.style.minWidth = (picker.up('combobox').getSize().width+100)+'px';
							return false;
						},10);
					}
				},
			}
		} ]
	}, {
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchURPFilterItemId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			itemId : 'resetURPFilterItemId',
			text : getCommonTranslation('RESET'),
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]
});