/**
 * Bhartendu Bhaskar
 */
Ext.define('Academia.view.resourceavailability.ResourceAvailabilityReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.resourceavailabilityreportgrid',
	store: 'resourceavailability.ResourceAvailabilityReportStore',
	title: getProgramandcourseTranslation('RESOURCE_AVAILABILITY_REPORT'),
	border: true,
	refreshStoreData: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{ 
		itemId: 'dockedItemsItemId',
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			store: 'resourceavailability.ResourceAvailabilityReportStore',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo: true
		}]
	}],
	initComponent: function() {
		var grid = this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	columns: [{
		header: getCommonTranslation('ROOM_NO'),
		dataIndex: 'roomName',
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('COMMITTEE_PARTICIPANT_NAME'),
		dataIndex: 'facultyName',
		hidden : true,
		flex: 1,
		sortable: true
	}, {
		header: getCommonTranslation('DATE'),
		dataIndex: 'date',
		flex: 1,
		sortable: true,
		hidden : true,
		renderer: function(date) {
			return dateRender(date);
		}
	}, {
		header: getCommonTranslation('DAY'),
		dataIndex: 'day',
		flex: 1,
		sortable: true,
		renderer: function(val) {
			return getCommonTranslation(val);
		}
	}, {
		header: getCommonTranslation('START_TIME'),
		dataIndex: 'startTime',
		flex: 1,
		sortable: true,
		renderer: function(fromTime) {
			return timeRender(fromTime);
		}
	}, {
		header: getCommonTranslation('END_TIME'),
		dataIndex: 'endTime',
		flex: 1,
		sortable: true,
		renderer: function(toTime) {
			return timeRender(toTime);
		}
	},{
		header: getCommonTranslation('NO_OF_COURSES_ASSOCIATED'),
		dataIndex: 'noOfAssociatedCourses',
		flex: 1,
		hidden : true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(record.data.totalCourseVariant == 0){
					return value;
				} else if(value > 0){
					return '<a href=#>'+value+'</a>'
				}else if(value == 0){
					return value;
				}
			}                        
		}
	}]
});