/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.resourceutilization.ResourceUtilizationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.resourceutilizationgrid',
	store : 'resourceutilization.ResourceUtilizationGridStore',
	title : getProgramandcourseTranslation('RESOURCE_UTILIZATION_GRID'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'resourceutilization.ResourceUtilizationGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	columns : [{
		header :getCommonTranslation('EVENT_PURPOSE'),
		dataIndex : 'eventPurpose',
		flex : 1,
		sortable : true,
		hidden : true
	}, {
		header :getCommonTranslation('EVENT_NAME'),
		dataIndex : 'eventName',
		flex : 1,
		sortable : true,
		hidden : true
	}, {
		header : getProgramandcourseTranslation('EVENT_FROM_DATE'),
		dataIndex : 'eventFromDate',
		flex : 1,
		sortable : true,
		hidden : true,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('EVENT_TO_DATE'),
		dataIndex : 'eventToDate',
		flex : 1,
		sortable : true,
		hidden : true,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header :getCommonTranslation('ROOM_NO'),
		dataIndex : 'roomName',
		flex : 1,
		itemId: 'roomMasterItemId',
		sortable : true
	}, {
		header : getTransportTranslation('USER_ID'),
		dataIndex : 'facultyCode',
		flex : 1,
		hidden : true,
		sortable : true
	}, {
		header : getCommonTranslation('COMMITTEE_PARTICIPANT_NAME'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('COURSE_CODE'),
		dataIndex : 'courseCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_NAME'),
		dataIndex : 'courseName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('STUDENT_ENROLLED'),
		dataIndex : 'enrolledCount',
		flex : 1,
		sortable : true,
		hidden : true
	},{
		header :getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1,
		sortable : true,
		hidden : true
	}, {
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true,
		hidden : true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true,
		hidden : true
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true,
		hidden : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1,
		sortable : true,
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		flex : 1,
		sortable : true,
		hidden : true,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('DAY'),
		dataIndex : 'day',
		flex : 1,
		sortable : true,
		renderer:function(day) {
			if(!isNullOrEmpty(day)){
				return getCommonTranslation(day);
			}
			else{
				return '';
			}
		}
	},{
		header : getCommonTranslation('START_TIME'),
		dataIndex : 'startTime',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('END_TIME'),
		dataIndex : 'endTime',
		flex : 1,
		sortable : true
	}, {
		header :getCommonTranslation('RESOURCES'),
		dataIndex : 'roomName',
		flex : 1,
		itemId: 'roomResourceEventItemId',
		sortable : true,
		hidden : true
	}, {
		header :getCommonTranslation('BOOKED_BY_USERID'),
		dataIndex : 'bookedByCode',
		flex : 1,
		sortable : true,
		hidden : true
	}, {
		header :getCommonTranslation('BOOKED_BY'),
		dataIndex : 'bookedBy',
		flex : 1,
		sortable : true,
		hidden : true
	}, {
		header :getCommonTranslation('NO_OF_PARTICIPANT'),
		dataIndex : 'noOfParticipants',
		flex : 1,
		sortable : true,
		hidden : true,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});
