/**
 * @author Priyanshi Sharma

 */



var applicableFor =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"STUDENT", "name":"Student"},
        {"value":"APPLICANT", "name":"Applicant"}]
});

var scholarshipCategory =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [{"value":"NOMINATION", "name":"Nomination"},
        {"value":"NSFAS", "name":"NSFAS"},
        {"value":"NRF", "name":"NRF"},
        {"value":"ALL", "name":"All"}]
});
Ext.define('Academia.view.scholarship.managescholarship.ManageScholarshipSearchFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.managescholarshipsearchfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'panelNoSpace',
	plugins:"formlabelrequired",
	items:[{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype: 'multiselectcombofield',
				name: 'academyLocationId',
				itemId: 'academyLocationItemId',
				fieldLabel:getCommonTranslation('ACADEMY_LOCATION'),
				width: 698,
				store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
				allowBlank : false,
				queryParam: "qry",
				valueField : 'id',
				forceSelection : true,
				displayField : 'value',
				hideTrigger:false,
				typeAhead:true,
				triggerAction: 'all',
				minChars:3,			
				emptyText: getCommonTranslation('ENTER_THREE_CHAR')			
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
					xtype: 'customcombobox',
					name:'applicableFor',
					store:applicableFor,
					itemId:'applicableFor',
					fieldLabel: getCommonTranslation('APPLICABLE_FOR'),
					valueField: 'value',
					displayField: 'name',
					value:'STUDENT',
					typeAhead:false,
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}'+ 
							'</div>';
						}
					}

				},{
					xtype: 'customcombobox',
					name: 'accountingYear',
					itemId: 'accountingYear',
					fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
					store:'scholarships.ScholarshipAccountingYearStore',
					valueField: 'id',
					displayField: 'currentAccountingYear',
					allowBlank:false,
					typeAhead:true,
					forceSelection:true
				},{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
	                itemId: 'scholarshipId',
	                name: 'scholarshipId',
	                enableKeyEvents: true,
	                disabled:true,
	                vtype: 'NospaceAsInput',
	                store:'scholarships.ManageScholarshipStore',
	    			valueField: 'id',
	    			displayField: 'valueCode',
	    			queryParam:'qry',
	    			minChars:3,
	    			typeAhead:false,
	    			//hideTrigger:true,
	    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{scholarshipCode} / {scholarshipName}' +
	    					'</div>';
	    				}
	    			}
	            },{
	    			xtype: 'customcombobox',
	    			fieldLabel: getCommonTranslation('SCHOLARSHIP_CATEGORY'), 
	    			name: 'scholarshipCategory',
	    			itemId: 'scholarshipCategory',
	    			store:scholarshipCategory,
    				valueField: 'value',
    				displayField: 'name',
    				queryMode : 'local',
    				hideTrigger:false,	 
    				value:'ALL',
    				triggerAction: 'all',
	            }]
			}]
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:240
			},
			items:[{
				xtype:'fieldcontainer',
				width:'100%',
				layout:'hbox',
				defaults:{
					labelAlign:'top',
					width:240
				},
				items:[{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_ID'),
	                itemId: 'scholarshipApplicationID',
	                name: 'scholarshipApplicationID',
	                enableKeyEvents: true,
	                vtype: 'NospaceAsInput',
	                store:'scholarships.ScholarshipApplicationIdStore',
	    			valueField: 'id',
	    			displayField: 'code',
	    			queryParam:'code',
	    			minChars:3,
	    			typeAhead:false,
	    			disabled:true,
	    			//hideTrigger:true,
	    			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			forceSelection:true,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{code}'  +
	    					'</div>';
	    				}
	    			}
	            },{
	            	xtype: 'customcombobox',
	            	fieldLabel: getCommonTranslation('STUDENT_STATUS'),
	            	name: 'stdStatus',
	            	itemId: 'stdStatus',
	            	editable: false,
	            	allowBlank:false,
	            	store: Ext.create('Ext.data.Store', {
	            		fields: ['name', 'value'],
	            		data : [{
	            			name:getCommonTranslation('SCHL_ACTIVE'), value:"ACTIVE"
	            		},{
	            			name:getCommonTranslation('SCHL_INACTIVE'), value:"INACTIVE"
	            		},{
	            			name:getCommonTranslation('SCHL_ALL'),value:'ALL'
	            		}]
	            	}),
	            	valueField: 'value',
	            	displayField: 'name',
	            	queryMode: 'local',
	            	value: 'ALL',
	            	forceSelection: false
	            },{
	                itemId: 'studentId',
	            	xtype: 'customcombobox',
	    			name: 'studentId',
	    			fieldLabel: getCommonTranslation('STUDENT_CODE_NAME'),
	    			store: Ext.create('Academia.store.feeandpayment.managebill.Student'),
	    			valueField: 'id',
	    			displayField: 'valueCode',
	    			queryParam:'studentNameOrCode',
	    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    			enableKeyEvents  : 'true',
	    			minChars:3,
	    			typeAhead:false,
	    			forceSelection:true,
	    			queryCaching: false,
	    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    			triggerAction: '',
	    			hideTrigger:false,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{studentCode} / {studentName}' +
	    					'</div>';
	    				}
	    			}
	            }, {
	              itemId: 'applicantId',
	            	xtype: 'customcombobox',
	    			name: 'applicantId',
	    			fieldLabel: getFeeAndPaymentCommonTranslation('APPLICANT_CODE_NAME'),
	    			store: 'feeandpayment.managebill.Applicant',
					valueField: 'id',
					displayField: 'printName',
					queryParam:'codeOrName',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					typeAhead:false,
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					forceSelection:true,
					hidden:true,
	    			listConfig: {
	    				listeners: {
	    					beforeshow: function(picker) {
	    						picker.minWidth = picker.up('combobox').getSize().width;
	    					}
	    				},
	    				loadingText: getCommonTranslation('SEARCHING'),
	    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    				getInnerTpl: function() {
	    					return '<div class="search-item">' +
	    					'{studentCode} / {studentName}' +
	    					'</div>';
	    				}
	    			}
	            },{
					xtype: 'customcombobox',
					name:'status',
					itemId:'status',
					store:'scholarships.ManageScholarshipStatusStore',
					fieldLabel: getCommonTranslation('STATUS'),
					valueField: 'id',
					displayField: 'value',
					typeAhead:false,
					value:'ALL',
					forceSelection:true,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}'+ 
							'</div>';
						}
					}

				}]
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls: 'customSearchPanelBtnsFieldContainerCls',
    		layout : {
    			type : 'hbox'
    		},
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtnItemID',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtnItemId',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	}]
});