/**
 * @author Suraj Chouhan
 *
 */
Ext.define("Academia.view.scholarship.managescholarship.ManageScholarshipUploadTemplateForm",{
    extend: "Ext.form.FormPanel",
    alias: "widget.managescholarshipuploadtemplateform",
    //plugins : "formlabelrequired",
    //autoScroll: true,
    frame: false,
    method: "POST",
    //cls:'customSearchPanel',
    standardSubmit: false,
    margin: '0 40 0 0',
    items: [{
        xtype: "fieldcontainer",
        width: "100%",
        layout: "hbox",
        defaults: {
          labelAlign: "top",
        },
      },{
		xtype:'uploadoptionradiogroup',
		width: 700,
        style: {'margin':'-20px 0 0 0'},
		itemId:'selectiontransferUploadOptionRadioGroupItemId',
	},{

			xtype: 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top'
			},
			items: [{
				xtype: 'customcombobox',
	            name: 'applicableFor',
	            itemId: 'applicableForId',
	            fieldLabel: getCommonTranslation('APPLICABLE_FOR'),
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            store:Ext.create('Academia.store.scholarships.ApplicableTypeStore'),
	            forceSelection:true,
	            allowBlank: false,
	            width: 256,
			},{
				xtype: 'customcombobox',
	            itemId:'templateForId',
	            editable: false,
	            displayField: 'value',
	            valueField: 'id',
	            fieldLabel: getCommonTranslation('TEMPLATE_FOR'),
	            name: 'templateFor',
	            store:Ext.create('Academia.store.scholarships.TemplateForTypeStore'),
	            forceSelection:true,
	            allowBlank: false,
	            width: 256,
			},
			{
				xtype: 'customcombobox',
				name: 'importUtilityMasterId',
				width: 280,
				itemId:'moduleName',
				store:'importutility.ModuleName',
				fieldLabel: getCommonTranslation('TEMPLATE_NAME'),
				valueField: 'id',
				displayField: 'value',
				readOnly:true,
				typeAhead:true,
				forceSelection:true,
				allowBlank:false
			}]
		
		},{
        xtype: "fieldcontainer",
        width: "100%",
        layout: "hbox",
        defaults: {
          labelAlign: "top",
        },
        items: [{
			xtype : 'filefield',
			ui : 'CustomBtnThird',
			width: 536,
			fieldLabel : getCommonTranslation('UPLOAD_FILE'),
			buttonText : getCommonTranslation('BROWSE_FILE'),
			itemId : 'uploadFileField',
			name : 'file',
			allowBlank:false,
			validateOnChange : true,
			listeners:{
	            change: function(fileField, value) {
	                value = value.replace('C:\\fakepath\\', '');
	                var newValue = value.replace(/ +/g, " ").split(' ').join('_');
	                fileField.setRawValue(newValue);
	                if (!isNullOrEmpty(newValue)) {
	                    var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
	                    var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
	                    if (!baseController.isValidFileExtensionForLoader(extension)) {
	                        fileField.reset();
	                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
	                    }
	                }
	            }
	        }
		}],
      }, {
        xtype: "fieldcontainer",
        width: "100%",
        layout: "hbox",
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
			xtype: 'button',
			action: 'Submit',
			text: getTranslation('UPLOAD_DATA'),
			formBind: true,
			itemId: 'uploadTemplateBtnId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			ui: 'CustomBtnCancel',
			itemId: 'resetBtn',
			scale: CONSTANTS.BUTTONSIZE
		}]
      }]
  });

