/**
 * Scholarship Cancel Request Window
 * @author Sanjeev Ranjan
 */
Ext.define('Academia.view.scholarship.managescholarship.ScholarshipDeleteConfirmationWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.scholarshipDeleteConfirmationWindow',
	title:getCommonTranslation('SCHOLARSHIP_REJECTION'),
	modal: true,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			layout:'vbox',
			defaults : {
				labelAlign : 'top'
			},
			items : [
				{
					xtype: 'displayfield',
			        fieldLabel: getFeeAndPaymentCommonTranslation('ARE_YOU_SURE_YOU_WANT_TO_CANCEL_SETTLEMENT'),
			        cls:'ScholarshipNumber',
			        width : 400,
				},{
					xtype: 'displayfield',
					labelSeparator:'',
					width : 400,
					cls:'scholarshipDetailFormCls',
			        fieldLabel: getCommonTranslation('REJECTION_REASON')+': <span class="required" style="color:red"> *</span>',
				},
				{
				xtype: 'customcombobox',
				name: 'cancellationReason',
				itemId:'cancellationReason',
				//fieldLabel: getCommonTranslation('CANCEL_SETTLEMENT'),
				store:Ext.create('Academia.store.common.ManageScholarshipDeleteApi'),
				valueField: 'id',
				displayField: 'value',
				width: 256,
				editable:false,
				hidden:false,
				forceSelection:true,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SUBMIT'),
				itemId : 'submitButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'cancelButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
    }]
});