/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.scholarship.poetmaster.PoetSetupForm', {
	extend: 'Ext.form.Panel',
	alias: 'widget.poetsetupform',
	autoScroll: true,
	frame: true,
	border:true,
	plugins : "formlabelrequired",
	layout:'vbox',
	title: getCommonTranslation('BASIC_POET_DETAILS'),
	cls:'x-form-fixed-footer-parent',

	items: [{
		xtype:'hidden',
		name:'id'
	},
	{
		xtype:'fieldcontainer',
		layout:'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		collapsible: false,
		items:[{
			xtype: 'textfield',
			name: 'projectNumber',
			itemId:'projectNumberItemId',
			fieldLabel: getCommonTranslation('PROJECT_NUMBER'),
			allowBlank:false
		},
		{
			xtype: 'textfield',
			name: 'projectName',
			itemId:'projectNameItemId',
			fieldLabel: getCommonTranslation('PROJECT_NAME'),
			allowBlank: false
		},
		{
			xtype: 'textfield',
			name: 'projectId',
			itemId:'projectIdItemId',
			fieldLabel: getCommonTranslation('PROJECT_ID'),
			allowBlank: false
		}]
	},

	{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name: 'feeHeadName',
			itemId:'feeHeadNameItemId',
			allowBlank:false,
			fieldLabel: getCommonTranslation('FEE_HEAD'),
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			store: 'scholarships.PoetMasterFeeHeadStore',	
			valueField: 'id',
			displayField: 'feeHeadName',
			queryParam:'codeOrName',
			enableKeyEvents: true,
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}/{printName}' +
					'</div>';
				}
			}
		}]

	},{
		xtype:'panel',
		itemId:'taskPanelItemId',
		frame: true,
		border:true,
		title: getCommonTranslation('TASK_DETAILS'),
		collapsible: true,
		width: '100%',
		//height: 'auto',
		layout : {
			type : 'vbox'
		},
		/*style: {
			margin: 0,
			marginTop:'10px',
			padding: 10
		},*/
		plugins : "formlabelrequired",
		items:[]
	},{
		xtype:'panel',
		itemId:'contractDetailsPanelItemId',
		frame: true,
		border:true,
		title: getCommonTranslation('CONTRACT_DETAILS'),
		collapsible: true,
		width: '100%',
	    margin: '0 0 60 0',
		//height: 'auto',
		layout : {
			type : 'vbox'
		},
		/*style: {
			margin: 0,
			marginTop:'10px',
			padding: 0
		},*/
		items:[]
	},{
		xtype: 'fieldcontainer',
		//style : {marginTop:'10px'},
		width: 'auto',
		cls:'form-fixed-footer',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			formBind: true,
			itemId: 'SubmitBtn',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getTransportTranslation('RESET'),
			itemId: 'btnCancel',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel',
			itemId: 'CancelBtnPOETForm',
			hidden:true,
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]
});