/**
 * 
 * @author priyanshi sharma
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.SPScholarshipListGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.spscholarshiplistgrid',
    store : 'scholarships.SPScholarshipListGridStore',
    title: getCommonTranslation('SCHOLARSHIP_LIST'),
    border: true,
    autoScroll: false,
    isGridConfigurable: true,
	enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
	tbar: [], //for spacing
	columns: [{
		header:  getCommonTranslation("SCHOLARSHIP_APPLICATION_NUMBER"),
		dataIndex:'scholarshipApplicationNo',
		flex:1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(!Ext.isEmpty(record.get("scholarshipRaiseRequestId"))) {
				return 'Req'+ value;
			}else{
				return value;
			}
		}
	},{
		header:  getCommonTranslation("SCHOLARSHIP_ID"),
		dataIndex:'scholarshipCode',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("SCHOLARSHIP_NAME"),
		dataIndex: 'scholarshipName',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("ACCOUNTING_YEAR"),
		dataIndex: 'accountingYear',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("PROGRAM"),
		dataIndex: 'programName',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("BATCH"),
		dataIndex: 'batchName',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("AMOUNT"),
		dataIndex: 'amount',
		flex:1,
		sortable:true,
	},{
		header:  getCommonTranslation("SCHOLARSHIP_APPLICATION_STATUS"),
		dataIndex: 'scholarShipRequstStatusDepartmental',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
				if(!Ext.isEmpty(record.get("scholarshipRaiseRequestId"))){
					switch(record.get("scholarShipRequstStatusDepartmental")) {
					case 'APPROVED':
					  case 'Approved':
					  case 'ASSIGNED':
					  case 'REASSIGNED':
					  case 'NOMINATED':
						  return getCommonTranslation("NOMINATED");
					    break;
					  case 'REJECTED':
					  case 'REJECTED_BO':
						  return getCommonTranslation("REJECTED");
					    break;
					  case 'CLOSED':
						  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					    break;
					  default:
						  break;
					}
				}else{
					switch(record.get("scholarShipRequstStatusNomination")) {
					case 'NOMINATED':
						  return getCommonTranslation("NOMINATED");
						  break;
					  case 'ACCEPTANCE_PENDING': 
						  return getCommonTranslation("ACCEPTANCE_PENDING");
						  break;
					  case 'REJECTED':
						  return getCommonTranslation("REJECTED");
					    break;
					  case 'DECLINED':
						  return getCommonTranslation("DECLINED");
					    break;
					  case 'ACCEPTED':
						  return getCommonTranslation("ACCEPTED");
					    break;
					  case 'AWARDED':
						  return getCommonTranslation("AWARDED");
					    break;
					  case 'DOCUMENT_RE_SUBMISSION':
						  return getCommonTranslation("DOCUMENT_RE_SUBMISSION");
						    break;
					  case 'AWARD_ACTIVATION_PENDING':
						  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
						    break;
					  case 'VERIFICATION_IN_PROGRESS':
						  return getCommonTranslation("VERIFICATION_IN_PROGRESS");
					  default:
						  break;
					}
				}
		} 
	},{
		header:  getCommonTranslation("AWARD_STATUS"),
		dataIndex: 'awardStatus',
		flex:1,
		sortable:true,
		renderer:function(value,meta,record){
			switch(record.get("awardStatus")) {
			case 'SCHOLARSHIP_ACTIVATED':
				  return getCommonTranslation("AWARDED");
				  break;
			  case 'AWARD_ACTIVATION_REJECTED': 
				  return getCommonTranslation("REJECTED");
				  break;
			  default:
				  break;
			}
		}

	},{
		header: getCommonTranslation("ACTION"),
		dataIndex: 'acceptAndRejectButton',
		sortable:false,
		flex:1.5,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			if(Ext.isEmpty(record.get("scholarshipRaiseRequestId"))){
				if(record.get("scholarShipRequstStatusNomination")=='ACCEPTANCE_PENDING' || record.get("scholarShipRequstStatusNomination")=='DOCUMENT_RE_SUBMISSION'){
					return "<div style='display:flex;margin-left:20px !important;'><button type='button' class='firstButtonClsInGridRow'>"+getCommonTranslation('ACCEPT')+"</button> &nbsp <button type='button' class='secondButtonClsInGridRow'>"+getCommonTranslation('DECLINE')+"</button></div>";
				}else if(record.get("scholarShipRequstStatusNomination")=='VERIFICATION_IN_PROGRESS'){
					return "<div style='display:flex;margin-left:38px !important;'><button type='button' class='secondButtonClsInGridRow'>"+getCommonTranslation('DECLINE')+"</button></div>";
				}
			}else{
				return '';
			}
		}
	}]
});