/**
 * Scholarship Cancel Request Window
 * @author Akanksha Sharma
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.ScholarshipCancelConfirmationWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.scholarshipCancelConfirmationWindow',
	title:getCommonTranslation('SCHOLARSHIP_CANCELLATION'),
	modal: true,
    autoScroll: true,
    frame: true,
    maxHeight : 550,
    items: [{
		xtype:'form',
		plugins : "formlabelrequired",
		items : [{
			xtype : 'fieldcontainer',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype: 'customcombobox',
				name: 'cancellationReason',
				itemId:'cancellationReason',
				fieldLabel: getCommonTranslation('CANCELLATION_REASON'),
				store: 'scholarships.SchlCancellationReasonStore',
				valueField: 'id',
				displayField: 'value',
				hidden:true,
				forceSelection:true,
				allowBlank:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.width = picker.up('combobox').getSize().width;
						}
					}
				}
			}]
		},{
			xtype : 'fieldcontainer',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [ {
				xtype: 'hidden',
				itemId: 'id'
			},{	
				xtype: 'textarea',
				width: 536,
				name: 'reasonForCancelScholarship',
				itemId:'reasonForCancelScholarship',
				cls:'billCancelBoxCLSBold',
				allowBlank:false,
				maxLength: 1000,
				fieldLabel: getCommonTranslation('SCHOLARSHIP_CANCELLATION_REASON_TITLE'),
			},{
				xtype: 'textarea',
				width: 536,
				name: 'remark',
				itemId:'remark',
				maxLength: 1000,
				hidden:true,
				fieldLabel: getCommonTranslation('Remark'),
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SUBMIT'),
				itemId : 'submitButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			}, {
				xtype: 'button',
				text : getCommonTranslation('CANCEL'),
				itemId : 'cancelButtonId',
				buttonAlign : 'left',
				ui : 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
    }]
});