/**
 *  @author Vyabha.thakur
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.ImportIntellimaliBulkUploadGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.importintellimalibulkuploadgrid',
	store : 'importutility.ImportIntelliMaliStore',
	border: true,
	reserveScrollbar:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'importutility.ImportIntelliMaliStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		text: getCommonTranslation('IMPORT_DATA'),
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('IMPORT_DATA'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: getCommonTranslation('DOWNLOAD_TEMPLATE'),
		itemId: 'btnDownloadTemp',
		tooltip: getCommonTranslation('DOWNLOAD_TEMPLATE'),
		glyph: ICONGLYPH.ADDGLYPH,
		hidden:true
	},{
		xtype: 'button',
		text: 'Refresh',
		itemId: 'btnRefresh',
		tooltip: 'Refresh',
		handler: function(){
			var myGridStore = this.ownerCt.ownerCt.getStore();
			myGridStore.reload();
		}
	},{
		xtype: 'button',
		text: getCommonTranslation('IMPORT_UTILITY_FORCE_RUN'),
		itemId: 'btnForce',
		tooltip: 'Force run job',
	}],
	columns: [{
		header : getCommonTranslation('MODULE_NAME'),
		dataIndex : 'importUtilityMaster',
		flex : 1,
		renderer:function(obj){
			if(obj.value){
				return  obj.value;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_FILE_NAME'),
		dataIndex : 'originalFileName',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+value+'</a>';
			}
		}	
	},{
		header : getCommonTranslation('UPLOADED_BY'),
		dataIndex : 'uploadedBy',
		flex : 1,
		renderer:function(obj){
			if(obj.value){
				return  obj.value;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'importedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	},{
		header : getCommonTranslation('PROCESSING_STATUS'),
		dataIndex : 'status',
		flex : 1
	},{
		header : getCommonTranslation('PROCESSED_ON'),
		dataIndex : 'processedOn',
		flex : 1,
		renderer: function(val){
			var mergedDate = dateRender(val)+' '+timeRender(val);
			return mergedDate;
		}
	},{
		header : getCommonTranslation('FAILURE_FILE'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if(value == 'Partially Processed'){
				return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
			}
		}
	},{
		header : getCommonTranslation('IMPORT_LOG_FILE'),
		dataIndex : 'whetherRecordFail',
		flex : 1,
		renderer:function(value){
			if(value){
				return  '<a href="#">'+getCommonTranslation('DOWNLOAD')+'</a>';
			}
		}
	}]
});
