Ext.define('Academia.view.scholarship.scholarshipmaster.ScholarshipRequestListGridStudent', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.scholarshipRequestListGridStudent',
	store: 'scholarshipRequest.ScholarshipRequestListStore',
	title: getCommonTranslation('LIST_OF_STUDENT_SCHOLARSHIP_REQUEST'),
	border: true,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'scholarshipServiceListMaster':1
		}
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarshipRequest.ScholarshipRequestListStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	selType: 'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip : getCommonTranslation('DELETE'),
		iconCls: 'icon-Delete',
		cls:'iconDelete',
		disabled: true
	}],
	
	columns: [{
		header:  getCommonTranslation('REQUEST_ID'),
		dataIndex:'requestId',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(!Ext.isEmpty(record.get("id"))) {
				return '<a href="javascript:void(0)">'+'Req'+ record.get("id") + '</a>';
			}
			return value;
		}
	},{
		header:  getCommonTranslation('REQUEST_BY'),
		dataIndex:'requestBy',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			return record.get("requestByName");
		}
	},{
		header:  getCommonTranslation('STUDENT_CODE_NAME'),
		dataIndex:'studentCodeName',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			return record.get("studentCode")+'/'+record.get("studentName");
		}
	},{
		header: getCommonTranslation('PROGRAM'),
		dataIndex:'programName',
		flex:.1,
		sortable:true
	},{
		header:  getCommonTranslation('REQUESTER_TYPE'),
		dataIndex:'requestType',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			return record.get("requesterType");
		}
	},{
		header:  getCommonTranslation('REQUEST_DATE'),
		dataIndex:'requestDate',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(!Ext.isEmpty(value)) {
				return dateRender(value);
			}
			return value
		}
	},{
		header:  getCommonTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex:'assigndTo',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			return record.get("assignedToName");
		}
	},{
		header:  getCommonTranslation("AMOUNT"),
		dataIndex:'amount',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			return record.get("totalScholarshipAmount");
		} 
	},{
		header:  getCommonTranslation('REQUEST_STATUS'),
		dataIndex:'requestStatus',
		flex:.1,
		sortable:true,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.get("requestStatus"))) {
				switch(record.get("requestStatus")) {
				case 'ASSIGNED':
					return getCommonTranslation("ASSIGNED_TO_LINE_MANAGER");
					break;
				case 'APPROVED':
				case 'Approved': 
					return getCommonTranslation("APPROVED_BY_LINE_MANAGER");
					break;
				case 'REASSIGNED':
					return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
					break;
				case 'REJECTED':
				case 'REJECTED_BO':
					return getCommonTranslation("REJECTED");
					break;
				case 'CLOSED':
					return getCommonTranslation("AWARD_ACTIVATION_PENDING");
					break;
				case 'RESUBMITTED':
					return 'Re-Submitted';
					break;
				default:
					break;
				}
			} 
			return value;
		} 
	},{
		header: getCommonTranslation('LAST_ACTION_DATE'),
		dataIndex:'lastUpdate',
		flex:.1,
		sortable:true,
		renderer: function(value,metaData,record) {
			if(!Ext.isEmpty(value)) {
				return dateRender(value);
			}
			return value
		}
	},{
		header: getCommonTranslation('ACTIONED_BY'),
		dataIndex:'lastUpdatedByName',
		flex:.1,
		sortable:true
	}]
});
