/**
 * @author priyanshi sharma
 *  
 */
Ext.define('Academia.view.scholarshipRequest.FollowUpDetailsScholarshipForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.followupdetailsscholarshipform',
    title : getCommonTranslation('FOLLOW_UP_DETAIL'),
    collapsible: true,
    frame : true,
    defaults:{
    	    	width:'100%'
    	   },
      layout:'vbox',
    style :{
    	marginLeft : '16px',
    },
    autoScroll: true,
			items : [{
				xtype: 'fieldcontainer',
				cls:'hideTotalRecord',
				items : [{
		        	xtype:'grid',
		        	itemId:'followUpGrid',
		        	border: true,
					hidden:true,
					cls:'folloupGridCls',
					viewConfig: {
						stripeRows: CONSTANTS.STRIPEROWS
					},
		        	store: {
		                fields: ['reviewerUserName', 'executionDate', 'reviewerStatus', 'followUpRemark'],
		                autoLoad: false,
		            	proxy:{
		            	type:'rest',
		            		api:{
		            		    read:SERVERURL.PATH_GRID_DATA_FOLLOWUP_DETAIL
		            		}
		            	}
		            },
		        	columns: [
		        	    {
		        	    	header:  getCommonTranslation('REVIEWED_BY'),
		        			dataIndex:'reviewerUserName',
		        			flex:.1,
		        			sortable:true,
		        	    },
		        	    {
		        	    	header:  getCommonTranslation('REVIEW_DATE'),
		        			dataIndex:'executionDate',
		        			flex:.1,
		        			sortable:true,
		        			renderer: function(value,metaData,record) {
		        				if(!Ext.isEmpty(value)) {
		        					return dateRender(value);
		        				}
		        				return value
		        			}
		        	    },
		        	    {
		        	    	header:  getCommonTranslation('STATUS'),
		        			dataIndex:'reviewerStatus',
		        			flex:.1,
		        			sortable:true,
		        			renderer:function(value,meta,record){
		        				if(!isNullOrEmpty(value)) {
		        					switch(value) {
		        					  case 'ASSIGNED':
		        						  return getCommonTranslation("ASSIGNED_TO_LINE_MANAGER");
		        					    break;
		        					  case 'APPROVED':
		        						  return getCommonTranslation("APPROVED_BY_LINE_MANAGER");
		        					    break;
		        					  case 'REASSIGNED':
		        						  return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
		        					    break;
		        					  case 'REJECTED':
		        						  return getCommonTranslation("REJECTED");
		        					    break;
		        					  case 'CLOSED':
		        						  return getCommonTranslation("AWARD_ACTIVATION_PENDING");
		        					    break;
		        					  case 'RESUBMITTED':
		        						  return getCommonTranslation("RE_ASSIGNED_TO_ADMIN");
		        					    break;
		        					  default:
		        						  break;
		        					}
		        					
		        				} 
		        				return value;
		        			} 
		        	    },
		        	    {
		        	    	header:  getFeeAndPaymentCommonTranslation('REMARK'),
		        			dataIndex:'followUpRemark',
		        			flex:.1,
		        			sortable:true,
		    				maxLength:1000
		        	    }
		        	]
		        }]
			},{
				xtype: 'fieldcontainer',
		        layout: {
		            type: 'hbox'
		        },
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
				items : [{
		        	xtype: 'displayfield',
		        	fieldLabel: getCommonTranslation('USER_NAME'),
		        	itemId: 'userName',
		        	name: 'userName',
				},{
		        	xtype: 'datefield',
		        	fieldLabel: getCommonTranslation('REQUEST_EXECUTED_ON'),
		        	itemId: 'reqExecutedOn',
		        	name: 'reqExecutedOn',
		        	editable: false,
		        	hideTrigger:true,
		        	listeners: {
		        		render: function(field) {
		        			field = dateFormatRender(field);						
		        			field.setValue(new Date());
		        		}
		        	},
				}]
			},{
				xtype: 'fieldcontainer',
		        layout: {
		        	width: 256,
		        },
		        defaults: {
					   labelAlign: 'top',
					   width: 360,
			        },
		        items : [{
		        	xtype:'textarea',
		        	fieldLabel : getCommonTranslation('FOLLOW_UP_REMARKS'),
		        	itemId: 'followUpRemarks',
		        	name:'followUpRemarks',
					maxLength:1000,
					fieldStyle: 'border: 1px solid #d9d9d9 !important;'
		        }]
			},{
				xtype: 'fieldcontainer',
				itemId:'declarationContainerId',
				hidden:true,
		        layout: {
		            type: 'hbox'
		        },
		        items : [{
		        	xtype:'checkbox',
		        	itemId: 'declarationFollowUp',
		        	name:'declarationFollowUp',
		        },{
		        	xtype:'displayfield',
		        	itemId: 'declarationText',
		        	name:'declarationText',
		        	width: 900,
		        	cls:'declarationFieldCls',
		        	value:getCommonTranslation('DECLARATION_FOR_LINE_MANAGER_1')+'<br><br>'+getCommonTranslation('DECLARATION_FOR_LINE_MANAGER_2'),
		        }]
			}]
});