/**
 * @author priyanshi sharma
 */
var costCentreOrPoetDetails = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"value":"COST_CENTER", "name":"Cost Centre"},
        {"value":"POET", "name":"POET"}] 
});

var workStatusData =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data : [
        {"name":getCommonTranslation('FULL_TIME_STUDENT'), "value":"FULL_TIME_STUDENT"},
        {"name":getCommonTranslation('PART_TIME_STUDENT'), "value":"PART_TIME_STUDENT"},
        {"name":getCommonTranslation('STAFF_MEMBER'), "value":"STAFF_MEMBER"},
        {"name":getCommonTranslation('EMPLOYED_ELSEWHERE'), "value":"EMPLOYED_ELSEWHERE"}]
});

Ext.define('Academia.view.scholarshipRequest.ScholarshipRequestForm',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias:'widget.scholarshiprequestform',
	plugins: "formlabelrequired",
	method: 'POST',
	layout: {
		type: 'vbox'
	},
	cls: 'x-form-fixed-footer-parent',
	items :[{
		xtype: 'fieldset',
		title: getCommonTranslation('REQUESTER_DETAILS'),
		layout:'vbox',
		collapsed: false,
		items: [{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 320,
				labelAlign : 'top'
			},
			items: [{
				xtype: 'hidden',
				itemId: 'recordId',
				name: 'recordId',
			},{
				xtype: 'hidden',
				itemId: 'stdStatusId',
				name: 'stdStatus',
			},{
        	xtype: 'displayfield',
        	fieldLabel: getCommonTranslation('STUDENT_ID_NAME'),
        	itemId: 'studentId',
        	name: 'studentId',
        	hidden:true
        },{
        	xtype: 'displayfield',
        	fieldLabel: getCommonTranslation('APPLICANT_ID_NAME'),
        	itemId: 'applicantId',
        	name: 'applicantId',
        	hidden:true
        }, {
        	xtype: 'displayfield',
        	fieldLabel: getCommonTranslation('BATCH'),
        	itemId: 'batchId',
        	name: 'batchId',
        },{
        	xtype: 'displayfield',
        	fieldLabel: getCommonTranslation('REQUESTER_TYPE'),
        	itemId: 'requesterTypeId',
        	name: 'requesterTypeId',
        }]
		}, {
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 320,
				labelAlign : 'top'
			},
			items: [{
				xtype: 'displayfield',
				fieldLabel: getCommonTranslation('PROGRAM'),
				itemId: 'programId',
				name: 'programId',
			}, {
				xtype: 'displayfield',
				fieldLabel: getCommonTranslation('EMAIL'),
				itemId: 'emailId',
				name: 'emailId',
			}, {
				xtype: 'displayfield',
				fieldLabel: getCommonTranslation('MOBILE'),
				itemId: 'mobileId',
				name: 'mobileId',
			}]
		}]
	},{
		xtype: 'fieldset',
		title: getCommonTranslation('BASIC_DETAILS'),
		layout:'vbox',
		collapsed: false,
		items: [{
	        xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'textfield',
	        	fieldLabel: getCommonTranslation('REQUEST_ID'),
	        	name: 'requestId',
	        	itemId: 'requestId',
	        	readOnly:true,
	        	hidden:true
	        },{
	        	xtype: 'customcombobox',
	        	fieldLabel: getCommonTranslation('REQUEST_BY'),
	        	name: 'requestById',
	        	itemId: 'requestById',
	        	valueField: 'value',
	        	displayField: 'name', 
	        	editable: false,
	        	hideTrigger:true,
	        },{
	        	xtype: 'datefield',
	        	fieldLabel: getCommonTranslation('REQUEST_DATE'),
	        	name: 'requestDateId',
	        	itemId: 'RequestDateId',
	        	editable: false,
	        	labelSeparator:'',
	        	hideTrigger:true,
	        	readOnly: true,
	        	listeners: {
	        		render: function(field) {
	        			field = dateFormatRender(field);		
	        			field.setValue(new Date());
	        		},
	        		focus: function(obj) {
	        			obj.getPicker().hide();
	        		}
	        	}
	        },{
	        	xtype: 'customcombobox',
	        	name: 'assigneeToId',
	        	itemId: 'assigneeToId',
	        	fieldLabel: getCommonTranslation('ASSIGNED_TO'),
	        	store: 'scholarshipRequest.RequestAssignedToUserStore',
	        	displayField: 'valueCode',
	        	valueField: 'id',
	        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	queryParam:'qry',
	        	minChars:3,
	        	enableKeyEvents  : 'true',
	        	hideTrigger:false,
	        	allowBlank: false,
	        	forceSelection:true,
	        	hidden:false,
	        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	listConfig: {
	        		loadingText: getCommonTranslation('SEARCHING'),
	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		listeners: {
	        			beforeshow: function(picker) {
	        				picker.width = picker.up('combobox').getSize().width;
	        			}
	        		},
	        	}
	        }]
	    },{
	        xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 256,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype: 'customcombobox',
	        	name: 'scholarshipId',
	        	itemId: 'scholarshipId',
	        	fieldLabel: getCommonTranslation('SCHOLARSHIP_ID_NAME'),
	        	store: 'scholarshipRequest.ScholarshipStore',
	        	displayField: 'valueCode',
	        	valueField: 'id',
	        	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	queryParam:'qry',
	        	minChars:3,
	        	enableKeyEvents  : 'true',
	        	hideTrigger:false,
	        	forceSelection:true,
	        	allowBlank:false,
	        	hidden:false,
	        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	listConfig: {
	        		loadingText: getCommonTranslation('SEARCHING'),
	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		listeners: {
	        			beforeshow: function(picker) {
	        				picker.minWidth = picker.up('combobox').getSize().width;
	        			}
	        		},
	        	}
	        },{
	        	xtype: 'customcombobox',
	        	fieldLabel: getCommonTranslation('ACCOUNTING_YEAR'),
	        	name: 'financialYear',
	        	itemId: 'financialYear',
	        	store: 'scholarshipRequest.AcademicYearScholarshipStore',
	        	valueField: 'id',
	        	displayField: 'value', 
	        	editable: false,
	        	allowBlank:false,
	        	querymode: 'local',
	        	disabled:true,
	        	listConfig: {
	        		loadingText: getCommonTranslation('SEARCHING'),
	        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		listeners: {
	        			beforeshow: function(picker) {
	        				picker.minWidth = picker.up('combobox').getSize().width;
	        			}
	        		},
	        	}
	        },{
	        	xtype: 'customcombobox',
	        	fieldLabel: getCommonTranslation('WORK_STATUS_OF_THE_STUDENT'),
	        	name: 'workStatusOfStudent',
	        	itemId: 'workStatusOfStudent',
	            store:workStatusData,
	        	valueField: 'value',
	        	displayField: 'name', 
	        	editable: false,
	        	querymode: 'local',
	        	hidden:true
	        },{
	        	xtype: 'customcombobox',
	        	fieldLabel: getCommonTranslation('WORK_STATUS_OF_THE_APPLICANT'),
	        	name: 'workStatusOfApplicant',
	        	itemId: 'workStatusOfApplicant',
	        	store:workStatusData,
	        	valueField: 'value',
	        	displayField: 'name', 
	        	editable: false,
	        	querymode: 'local',
	        	hidden:true
	        },{
	        	xtype:'radiogroup',
	        	itemId: 'liableForTax',
	            name:'liableForTax',
	            width: 462,
	            fieldLabel : getCommonTranslation('LIABLE_FOR_TAX'),
	            layout:'hbox',
	            items: [{
	                boxLabel: getCommonTranslation('YES'),
	                name: 'liableForTax',
	                itemId:'yesLiableForTaxId',
	                inputValue: true,
	            },{
	                boxLabel: getCommonTranslation('NO'),
	                name: 'liableForTax',
	                itemId:'noLiableForTaxId',
	                inputValue:false,
	                checked: true,
	        }]
	    }]
	    },{
	    	xtype: 'fieldcontainer',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults: {
	    		width: 462,
	    		labelAlign: 'top',
	    	},
	    	items: [{
	    		xtype:'radiogroup',
	    		itemId: 'stdUnderstandNoWorkDoneInExchangeOfBursary',
	    		name:'stdUnderstandNoWorkDoneInExchangeOfBursary',
	    		fieldLabel : getCommonTranslation('DOES_THE_STUDENT_UNDERSTAND_THAT_NO_WORK_MAY_BE_DONE_IN_EXCHANGE_FOR_THIS_BURSARY?'),
	    		layout:'hbox',
	    		hidden:true,
	    		cls:'scholarshipDetailFormCls',
	    		items: [{
	    			boxLabel: getCommonTranslation('YES'),
	    			name: 'stdUnderstandNoWorkDoneInExchangeOfBursary',
	    			itemId:'WorkDoneInExchangeOfBursaryYesId',
	    			inputValue: true,
	    			checked: true,
	    		},{
	    			boxLabel: getCommonTranslation('NO'),
	    			name: 'stdUnderstandNoWorkDoneInExchangeOfBursary',
	    			itemId:'WorkDoneInExchangeOfBursaryNoId',
	    			inputValue:false,
	    		}]
	    	},{
	    		xtype:'radiogroup',
	    		itemId: 'applicantUnderstandNoWorkDoneInExchangeOfBursary',
	    		name:'applicantUnderstandNoWorkDoneInExchangeOfBursary',
	    		fieldLabel : getCommonTranslation('DOES_THE_APPLICANT_UNDERSTAND_THAT_NO_WORK_MAY_BE_DONE_IN_EXCHANGE_FOR_THIS_BURSARY?'),
	    		layout:'hbox',
	    		hidden:true,
	    		cls:'scholarshipDetailFormCls',
	    		items: [{
	    			boxLabel: getCommonTranslation('YES'),
	    			name: 'applicantUnderstandNoWorkDoneInExchangeOfBursary',
	    			itemId:'applicantUnderstandNoWorkDoneInExchangeOfBursary',
	    			inputValue: true,
	    			checked: true,
	    		},{
	    			boxLabel: getCommonTranslation('NO'),
	    			name: 'applicantUnderstandNoWorkDoneInExchangeOfBursary',
	    			itemId:'WorkDoneInExchangeOfBursaryNoId',
	    			inputValue:false,
	    		}]
	    	},{
	    		xtype:'radiogroup',
	    		itemId: 'subsequentScholarshipAvailable',
	    		name:'subsequentScholarshipAvailable',
	    		fieldLabel : getCommonTranslation('SUBSEQUENT_SCHOLARSHIP_AVAILABLE'),
	    		layout:'hbox',
	    		//width: 256,
	    		cls:'scholarshipDetailFormCls',
	    		items: [{
	    			boxLabel: getCommonTranslation('YES'),
	    			name: 'subsequentScholarshipAvailable',
	    			itemId:'yesSubsequentScholarshipAvailable',
	    			inputValue: true,
	    		},{
	    			boxLabel: getCommonTranslation('NO'),
	    			name: 'subsequentScholarshipAvailable',
	    			itemId:'noSubsequentScholarshipAvailable',
	    			inputValue:false,
	    			checked: true,
	    		}]
	    	},{
	    		xtype:'numberfield',
	    		fieldLabel : getCommonTranslation('SUBSEQUENT_AMOUNT'),
	        	itemId: 'subsequentAmount',
	            name:'subsequentAmount',
	            width: 256,
	            maxLength:13,
	            hidden:true,
	            hideTrigger :true,
	    	}]
	    },{
		   xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	            width: 450,
	            labelAlign: 'top'
	        },
	        items: [{
	        	xtype:'displayfield',
	        	hidden:true,
	        	cls:'alertFieldCls',
	        	itemId: 'alertFieldIfNoIsSelectedInWorkDoneRadioBtn',
	            name:'alertFieldIfNoIsSelectedInWorkDoneRadioBtn',
	        }]
	   },{
		   xtype: 'fieldcontainer',
	        layout: {
	            type: 'hbox'
	        },
	        defaults: {
	        	xtype:'numberfield',
	            width: 256,
	            labelAlign: 'top',
	            hideTrigger :true,
	            minValue : 1,
				maxValue: 9999999999,
				maxLength:10,
	            cls:'scholarshipDetailFormCls',
	            hideTrigger: true,
				keyNavEnabled: false,
				mouseWheelEnabled: false,
				enableKeyEvents: true,
				allowDecimals:true
	        },
	        items: [{
	        	fieldLabel : getCommonTranslation('PAYMENT_TOWARDS_FEES'),
	        	itemId: 'paymentTowardsFees',
	            name:'paymentTowardsFees',
	        },{
	        	fieldLabel : getCommonTranslation('PAYMENT_TOWARDS_LIVING_EXPENSES_OR_ACCOMMODATION'),
	        	itemId: 'paymentTowardsLivingExpensesOrAccommodation',
	            name:'paymentTowardsLivingExpensesOrAccommodation',
	        },{
	        	fieldLabel : getCommonTranslation('OTHER'),
	        	itemId: 'Other',
	            name:'Other',
	        },{
	        	fieldLabel : getCommonTranslation('TOTAL_SCHOLARSHIP_AMOUNT'),
	        	itemId: 'totalScholarshipAmount',
	            name:'totalScholarshipAmount',
	            maxValue: 99999999999999999999,
				maxLength:20,
	            readOnly:true
	        }]
	   },{
		   xtype: 'container',  
		   itemId: 'costCentreOrPoetDetailsContainerId',
		   items:[{
		        xtype: 'fieldcontainer',
		        itemId: 'costCentreOrPoetDetailsFieldContainerId',
		        cls:'scholarshipDetailFormCls',
		        layout: {
		            type: 'hbox'
		        },
		        defaults: {
		            width: 256,
		            labelAlign: 'top'
		        },
		        items: [{
		        	xtype: 'customcombobox',
		        	fieldLabel: getCommonTranslation('COST_CENTRE_OR_POET_DETAILS'),
		        	name: 'costCentreOrPoetDetails',
		        	itemId: 'costCentreOrPoetDetails',
		        	store: costCentreOrPoetDetails,
		        	valueField: 'value',
		        	displayField: 'name', 
		        	editable: false,
		        	allowBlank:false
		        }]
		   }]
	   },{
		   xtype: 'fieldcontainer',
		   layout: {
			   type: 'vbox',
		   },
		   defaults: {
			   labelAlign: 'top',
			   width: 360,
	        },
	        items: [{
	        	xtype:'textarea',
	        	fieldLabel : getCommonTranslation('REMARKS'),
	        	itemId: 'remark',
	            name:'remark',
				maxLength:1000
	        }]
	   }]
	},{
		xtype:'followupdetailsscholarshipform',
		itemId:'followUpDetailsScholarshipFormId',
		hidden:true,
		width: 1200,
	},{
		xtype:'executiondetailsscholarshipform',
		itemId:'executiondetailsscholarshipformId',
		hidden:true,
		width: 1200,
	},{
		xtype: 'fieldcontainer',
		itemId:'declarationsContainerId',
		layout: {
			type: 'hbox'
		},
		style:{
			   marginLeft:'16px !important'
		   },
		items: [{
			xtype:'checkbox',
			itemId: 'declaration',
			name:'declaration',
		},{
			xtype:'displayfield',
			itemId: 'declarationText',
			name:'declarationText',
			width: 900,
			cls:'declarationFieldCls',
			value:getCommonTranslation('DECLARATION_FOR_FACUILTY_1')+'<br><br>'+getCommonTranslation('DECLARATION_FOR_FACUILTY_2'),
		}]
	},{
		xtype: 'fieldcontainer',    
		layout: 'hbox',
		width:'auto',
		cls: 'form-fixed-footer',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE_SCHOLARSHIP_FACULTY") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetScholarShipFormBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
		},{
			xtype : 'button',
			text : getCommonTranslation("REJECT") ,
			itemId : 'rejectBtn',
			ui : 'CustomBtnThird',
			hidden:true,
			disabled:true,
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation("APPROVE") ,
			itemId : 'approveBtn',
			hidden:true,
			disabled:true,
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype : 'button',
			text : getCommonTranslation("RESUBMIT") ,
			itemId : 'reSubmit',
			ui : 'CustomBtnSubmit',
			hidden:true,
			disabled:true,
			cls:'resubmitCls',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]
	}]
});