Ext.define('Academia.view.securitysetup.AccessRightsTree', {
    extend: 'Ext.tree.Panel',
    alias: 'widget.accessrighttree',
    xtype: 'tree-grid',
    titleCollapse: true,
    collapsible : true,
    style :{
    	marginLeft : '16px'
    },
    border : true,
    height: 300,
    rootVisible: false,
    singleExpand: true,
    requires: ['Ext.data.*',
               'Ext.grid.*', 
               'Ext.tree.*'],
    //TODO: manage store [RRA]
    store: 'securitysetup.AccessTree',

    tbar: [{
        xtype: 'splitbutton',
        itemId: 'btnAddPermissions',
        text: 'Add',      
        menu: [{
            text: getCommonTranslation('ACADEMY_LOCATION'),
            itemId: 'add_academyLocation',
            cls:'accessRightMenuBtnCls'
        }, {
            text: getCommonTranslation('ROLE'),
            itemId: 'add_acad_loc_role',
            cls:'accessRightMenuBtnCls'
        },/*, {
            text: getCommonTranslation('PRIVILEGES'),
            itemId: 'add_privilege'
        }*/ 
        {
            text: getCommonTranslation('MULTIPLE_ACADEMY_LOCATION_AND_ROLE'),
            itemId: 'multipleALandRolesId',
            cls:'accessRightMenuBtnCls'
        }]
    }, {
        xtype: 'splitbutton',
        itemId : 'btnAddAcademyLocation',
        text: 'Edit',
        menu: [{
            text: getCommonTranslation('ACADEMY_LOCATION'),
            itemId: 'edit_academyLocation',
            cls:'accessRightMenuBtnCls'
        }, {
            text:  getCommonTranslation('ROLE'),
            itemId: 'edit_acad_loc_role',
            cls:'accessRightMenuBtnCls'
        }, {
            text: getCommonTranslation('PRIVILEGES'),
            itemId: 'edit_privilege',
            cls:'accessRightMenuBtnCls'
        }, {
            text: getCommonTranslation('PROGRAM_AND_COURSES'),
            itemId:'edit_programCourse',
            cls:'accessRightMenuBtnCls'
        }]
    },{
        xtype: 'splitbutton',
        text: 'Unassign',
        itemId : 'btnUnassign',
        menu: [{
            text: getCommonTranslation('ACADEMY_LOCATION'),
            itemId: 'unassign_academyLocation',
            cls:'accessRightMenuBtnCls'
        }, {
            text:  getCommonTranslation('ROLE'),
            itemId: 'unassign_acad_loc_role',
            cls:'accessRightMenuBtnCls'
        }]
    }],
    columns: [{
        xtype: 'treecolumn', //this is so we know which column will show the tree
        text: getCommonTranslation('ACADEMY'),
        flex: 1,
        sortable: true,
        dataIndex: 'academy.value'
    }, {
        text: getCommonTranslation('LOCATION'),
        flex: 1,
        dataIndex: 'location.value'
    },  {
        text: getCommonTranslation('ROLE'),
        flex: 1,
        dataIndex: 'role.roleName',
        renderer: function(val) {
            return getCommonTranslation(val);
        }
    }, {
        text: getCommonTranslation('START_DATE'),
        flex: 1,
        dataIndex: 'startDate',
        renderer: function(date) {
            return dateRender(date);
        }        	
    }, {
        text: getCommonTranslation('END_DATE'),
        flex: 1,
        dataIndex: 'tillDate',
        renderer: function(date) {
            return dateRender(date);
        }
    }]

});