Ext.define('Academia.view.securitysetup.AssignRoleForm',{
	extend:'Ext.window.Window',
	alias:'widget.assignroleformwindow',
	title:getCommonTranslation('ASSIGN_ROLE'),
	 autoScroll: true,
	 maxHeight: 600,
	 frame: true,
	 modal: true,
	 plugins: "formlabelrequired",
	 items:[{
		 xtype:'form',
		 defaults: {
        	labelAlign:'top',
        	width: 256
          },
          items:[{
        	  xtype: 'hidden',
    		  name:'id'
    	},{
      	  xtype: 'hidden',
		  name:'version'
    	},{
      	  xtype: 'hidden',
		  name:'userAcademyLocation'
    	},{
    		xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('ROLE'),
			name:'role',
			itemId:'role',
			store : 'securitysetup.ActiveLockedAndUnLockedRolesStore',
			valueField : 'id',
			displayField : 'value',
			//editable:false,
			forceSelection :true,
			allowBlank:false,
			forceSelection :true,
			allowBlank:false,
			//queryParam:'roleName',
			minChars:3,
			typeAhead:false,
			hideTrigger:false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
          },{
              xtype: 'datefield',
              name: 'startDate',
              fieldLabel:getCommonTranslation('START_DATE'),
              vtype: 'daterange',
              itemId: 'startDate',
              endDateField:'tillDate',
              allowBlank: false,
              listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
          }, {
              xtype: 'datefield',
              name: 'tillDate',
              fieldLabel:getCommonTranslation('END_DATE'),
              itemId:'tillDate',
              vtype: 'daterange',
              startDateField: 'startDate',
              listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
          },{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
        	  xtype:'button',
        	  text:getCommonTranslation('SAVE'),
        	  formBind: true,
        	  itemId:'btnSaveRoleId',
        	  ui: 'CustomBtnSubmit',
              scale: CONSTANTS.BUTTONSIZE
          },{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel', 
			itemId: 'cancelBtn',
			scale: CONSTANTS.BUTTONSIZE

		}]
       }]
	 }]
});