Ext.define('Academia.view.securitysetup.ReleaseDetailWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.releasedetailwindow',
    cls: 'release-note-popup',
    title: getCommonTranslation('RELEASE_DETAIL'),
    width: 480,
    height: 270,
    modal: true,
    closable: true,
    resizable: false,

    initComponent: function () {
        var me = this;
        var store = Ext.create('Academia.store.systemusage.BuildInfoStore');


        this.items = [

            // content rows
            {
                xtype: 'fieldcontainer',
                width: '100%',
                defaults: {
                    xtype: 'container',
                    layout: 'hbox'
                    
                },
                items: [
                    {
                        items: [
                            { xtype: 'component', html: '<div class="release-label">Release Name:</div>', width: 150 },
                            { xtype: 'component', itemId: 'relName', flex: 1, html: '' }
                        ]
                    },
                    {
                        items: [
                            { xtype: 'component', html: '<div class="release-label">Release Date:</div>', width: 150 },
                            { xtype: 'component', itemId: 'relDate', flex: 1, html: '' }
                        ]
                    },
                    {
                        items: [
                            { xtype: 'component', html: '<div class="release-label">Version:</div>', width: 150 },
                            { xtype: 'component', itemId: 'relVersion', flex: 1, html: '' }
                        ]
                    }
                ]
            },

            // links block
            {
                xtype: 'fieldcontainer',
                width: '100%',
                html:
                    '<a class="release-link" href="https://www.academiaerp.com/" target="_blank">About Us</a> &nbsp;|&nbsp; ' +
                    '<a class="release-link" href="https://www.academiaerp.com/contact" target="_blank">Contact Us</a> &nbsp;|&nbsp; ' +
                    '<a class="release-link" href="https://www.academiaerp.com/privacy-policy" target="_blank">Privacy Policy</a>'

            },

            {
                xtype: 'fieldcontainer',
                width: '100%',
                items: [
                    {
                        xtype: 'button',
                        text: getCommonTranslation('OK'),
                        ui: 'CustomBtnSubmit',
            	        scale: CONSTANTS.BUTTONSIZE,
            	        cls: 'btn-with-no-icon',
                        handler: function(btn) {
                            btn.up('window').close();
                        }
                    }
                ]
            }

        ];

        this.callParent();

        // load XML and update components
        // store may already be defined/instantiated by your app launch
        if (store) {
            store.load({
                callback: function (records) {
                    if (!records || records.length === 0) return;
                    var rec = records[0];
                    me.down('#relName').update(Ext.String.htmlEncode(rec.get('buildName') || ''));
                    me.down('#relDate').update(Ext.String.htmlEncode(rec.get('buildDate') || ''));
                    me.down('#relVersion').update(Ext.String.htmlEncode(rec.get('buildVersion') || ''));
                }
            });
        } else {
            // fallback: try to lookup if store was created later
            var chk = Ext.data.StoreManager.lookup('BuildInfoStore');
            if (chk) {
                chk.load({
                    callback: function (records) {
                        if (!records || records.length === 0) return;
                        var rec = records[0];
                        me.down('#relName').update(Ext.String.htmlEncode(rec.get('buildName') || ''));
                        me.down('#relDate').update(Ext.String.htmlEncode(rec.get('buildDate') || ''));
                        me.down('#relVersion').update(Ext.String.htmlEncode(rec.get('buildVersion') || ''));
                    }
                });
            }
        }
    }
});
