Ext.define('Academia.view.securitysetup.UserBasicDetails',{	 
	extend:'Academia.view.common.IdGeneratorForm',
	/*mixins: {
	    extend: 'Academia.view.common.IdGeneratorForm'
	   },*/
	alias:'widget.userbasicdetails',
	titleCollapse: true,
	title:getCommonTranslation('BASIC_DETAILS'),
	padding: 10,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	autoScroll:true,
	cls:'x-form-fixed-footer-parent userbasicdetailsCls',
	plugins : "formlabelrequired",
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		defaults : {
			xtype:'textfield',
			labelAlign:'top',
			enforceMaxLength : true		
		},
		items:[{
			xtype: 'hidden',
			name:'id'
		},{
			xtype: 'hidden',
			name:'version'
		},{
			xtype: 'hidden',
			name:'personId',
			itemId:'personId'  
		},{
			xtype: 'hidden',
			name:'personVersion',
			itemId:'personVersion'  	  
		},{
			xtype: 'hidden',
			name:'bankId',
			itemId:'bankId'  
		},{
			xtype: 'hidden',
			name:'bankVersion',
			itemId:'bankVersion'  
		},{
			xtype:'nestedJsonCombo',
			name:'bankPerson',
			itemId:'bankPerson',
			hidden:true	
		},{
			xtype: 'container',
			layout: 'absolute',
			itemId:'photoViewPanelId',
			//hidden:true,
			width: 130,
		    height: 130,
			items: [{
				xtype:'image',
				itemId: 'profile_image',
				width: 130,
				height: 130,
				x: 0,
		        y: 0,
				style: { 					
					borderRadius: '70px',
					borderColor: 'rgb(224, 224, 224)',
				    borderStyle: 'solid',
				    borderWidth: '1px',
				},
			},{
			    xtype: 'container', // Using container to manage custom HTML
			    itemId: 'profile_image_icon',
			    width: 50,
			    height: 50,	
			    x: 100,
		        y: 90,
			    html: '<span class="hoverElement" style="display: inline-block; width: 28px; height: 28px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: 110px; background-color: #fff; top: 80px;">' +
			          '<img src="resources/images/Edit_Pro.svg" class="hoverImage" style="width: 100%; height: 100%; object-fit: cover;">' +
			          '</span>'
			},{
            	xtype:'hidden',
            	itemId: 'photoUrlItemId',
            	name: 'photoUrl'
            }]
		},
		{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('USER_ID'),
				//allowBlank:false,
				itemId:'code',
				name:'code',
					//TODO: verify and add proper id generation code - commented by Rupesh A.
					//emptyText: getCommonTranslation('ID_AUTOGENERATE'),
					//readOnly:true
			},{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('SALUTATION'),
			name:'salutation',
			store: 'common.SalutationStore',
			valueField: 'id',
			displayField: 'salutationName',
			allowBlank: false,
			editable: false
		}]},{
			xtype: 'text',
			text: ''
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype:'textfield',	
			fieldLabel:getCommonTranslation('FIRST_NAME'),
			allowBlank:false,
			name:'firstName',
			itemId:'firstName',
			regex: /^[^<]*$/,
		    regexText: 'Character "<" is not allowed',
			maxLength : 100,
			listeners: {
				blur: function(value) {
					value.setValue((value.getValue().replace(/\s+/g, " ")).trim());
		        },
			}
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
			name: 'firstNameOtherLanguage',
			itemId:'firstNameOtherLnguageId',
			maxLength : 100
			
		}
			
			,{
			xtype:'textfield',
			fieldLabel:getCommonTranslation('MIDDLE_NAME'),
			name:'middleName',
			itemId:'middleName',
			regex: /^[^<]*$/,
		    regexText: 'Character "<" is not allowed',
			maxLength : 53,
			listeners: {
				blur: function(value) {
					value.setValue((value.getValue().replace(/\s+/g, " ")).trim());
				},
			}
		}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLnguageId',
				maxLength : 53
			},{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('LAST_NAME'),
				name:'lastName',
				itemId:'lastName',
				regex: /^[^<]*$/,
			    regexText: 'Character "<" is not allowed',
				maxLength : 100,
				listeners: {
					blur: function(value) {
						value.setValue((value.getValue().replace(/\s+/g, " ")).trim());
					},
				}
				//allowBlank:false		
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLnguageId',
				maxLength : 100,
				
			}
		
		
		]}
		,
		{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('SHORT_NAME'),
			name:'shortName',
			itemId:'shortName',
			blur: {
				change: function(value) {
					value.setValue((value.getValue().replace(/\s+/g, " ")).trim());
				}
			}	
		},
				{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('SHORT_NAME_OTHER_LANGUAGE'),
					name: 'shortNameOtherLanguage',
					itemId: 'shortNameOtherLnguageId'
					
				},{
					xtype: 'textfield',
					fieldLabel: getCommonTranslation('USER_INITIALS'),
					name: 'initials',
					itemId: 'initialsId',
					maxLength : 5,
					enforceMaxLength :true,
					allowBlank: true,
					stripCharsRe: /[^0-9a-zA-Z]/g
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('NAME_TO_PRINT'),
					name:'printName',
					itemId:'printName',
					allowBlank: false,	
					listeners: {
						blur: function(value) {
							value.setValue((value.getValue().replace(/\s+/g, " ")).trim());
						},
					}
				}
								
				
			]
		},
		
		{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [
				{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('NAME_TO_BE_PRINTED_OTHER_LANGUAGE'),
					name: 'printNameOtherLanguage',
					itemId: 'printNameOtherLnguageId',
					//allowBlank: false
				
				},{
					xtype: 'nestedJsonCombo',
					fieldLabel: getCommonTranslation('GENDER'),
					name: 'gender',
					itemId:'genderCSM',
					valueField: 'id',
					displayField: 'value',
					store: 'Academia.store.common.GenderTypeStore',
					editable: false,
					allowBlank: false
				 },{
					xtype:'textfield',	
				fieldLabel:getCommonTranslation('EMAIL'),
				name:'emailId',
				vtype: 'email',
				allowBlank: false
			}

				
			]
		}
		,{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
			xtype:'fieldcontainer',
			labelSeparator : '',
			fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO')+'<span class="required" style="color:red"> *</span>',
			itemId:'userMobileCoutryCodeContainer',
			layout:'hbox',
			labelAlign:'top',
			items:[{
				xtype: 'customcombobox',
				valueField: 'isdCode',
				displayField: 'isdCode',
				store: Ext.create('Academia.store.common.CountryStore'),
				itemId:'mobileCountryCode',
				triggerAction: 'all',
				name: 'mobileCountryCode',
				width: 80,
				//typeAhead:true,
				forceSelection:true,
				emptyText: 'Code', 
				allowBlank:false,
				minChars: 1,
				emptyText:getCommonTranslation('ISD')
			},{
				xtype: 'numberfield',
				//fieldLabel:getCommonTranslation('ADDRESS_MOBILE_NO'),
				name:'mobileNumber',
				itemId: 'mobileNumber',
			    minLength: 0,
				maxLength: 15,
				spinUpEnabled : false,
				spinDownEnabled : false,
				hideTrigger : true,
				enforceMaxLength : true,
				allowBlank: false,
				width:176,
				 margin:'0 0 0 -25',
	            	emptyText:getCommonTranslation('ADDRESS_MOBILE_NO')
			}]},{
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
				name: 'birthDate',
				itemId : 'birthDateItemId',
				allowBlank: false,
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				listeners:{
					render:function(dateField){
						dateField = dateFormatRender(dateField);
						var date = new Date();
						date.setFullYear(date.getFullYear()-18);
						dateField.setMaxValue(date);
					}
				}
			  },{
					xtype:'textfield',	
					fieldLabel:getCommonTranslation('ALTERNATE_EMAIL_ID'),
					name:'alternateEmailId',
					itemId : 'alternateEmailId',
					vtype: 'email'
			 }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{ 
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('CALENDER'),
			name:'calendar',
			store: 'calendar.ActiveCalendarStore',
			valueField: 'id',
			displayField: 'value',
			allowBlank: false,
			editable: false
		},{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('ASSIGN_USER_GROUP_TYPE'),
			name:'userGroup',
			itemId : 'userGroupType',
			store: 'userGroup.UserGroupStore',
			valueField: 'id',
			displayField: 'userGroupName',
			allowBlank: false,
			editable: false,
			queryMode : 'local'
		}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
			xtype:'nestedJsonCombo',
			fieldLabel:getCommonTranslation('DEPARTMENT'),
			name:'department',
			itemId : 'departmentId',		
			store: 'department.ParentDepartmentByAccesibleStore',
			valueField: 'id',
			allowBlank: false,
			displayField: 'name',
			editable: false
		},{
			xtype:'checkbox',
			itemId : 'whetherFacultyId',
			name:'whetherFaculty',
			style: 'margin-top: 25px',
			boxLabel:getCommonTranslation('WHETHER_FACULTY'),
			inputValue: true,
			uncheckedValue: false
		},{
			xtype:'checkbox',
			itemId : 'whetherLeaveApplicableId',
			name:'whetherLeaveApplicable',
			style: 'margin-top: 25px',
			boxLabel:getCommonTranslation('WHETHER_LEAVE_APPLICABLE'),
			inputValue: true,
			uncheckedValue: false,
			hidden: false
		},/*{
			xtype: 'nestedJsonCombo',
			fieldLabel: getPersonModuleTranslation('FACULTY_TYPE'),
			store : 'common.FacultyTypeCSMStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'facultyTypeCSM',
			itemId:'facultyTypeId',
			allowBlank: false,
			editable: false,
			hidden:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getUserModuleTranslation('EMPLOYEE_TYPE'),
			store : 'user.EmployeeTypeStore',
			valueField: 'id',
			displayField: 'value',  
			name: 'employeeType',
			itemId:'employeeTypeId',
			allowBlank: false,
			editable: false,
			hidden:true
		}*/]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype: 'customcombobox',
				name:'leaveCategory',
				itemId:'leaveCategoryId',
				fieldLabel: getCommonTranslation('LEAVE_CATEGORY'),
				store:'securitysetup.LeaveCategorTypeStore',
				valueField: 'id',
				displayField: 'value',
				forceSelection: true,
				editable: false,
			}, {
			xtype:'checkbox',
			itemId : 'isInTimeOutTimeRequired',
			name:'isInTimeOutTimeRequired',
			style: 'margin-top: 25px',
			boxLabel:getCommonTranslation('IN_OUT_TIME_REQUIRED'),
			inputValue: true,
			uncheckedValue: false,
			checked:true,
		},{
			xtype:'checkbox',
			itemId : 'isTimesheetRequired',
			name:'isTimesheetRequired',
			style: 'margin-top: 25px',
			boxLabel:getCommonTranslation('TIMESHEET_REQUIRED'),
			inputValue: true,
			uncheckedValue: false,
			checked:true,
		}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype:'statusCombo',
				name:'status',
				value:true,
				allowBlank: false,
				editable:false
			},{
				xtype:'nestedJsonCombo',
				fieldLabel:getCommonTranslation('APPROVAL_DROOL'),
				name:'approvalDrool',
				itemId : 'approvalDrool',
				//store: 'userGroup.UserGroupStore',
				valueField: 'id',
				displayField: 'userGroupName',
				editable: false,
			//	queryMode : 'local',
			},{
				xtype:'checkbox',
				itemId : 'isPublishTimesheet',
				name:'isPublishTimesheet',
				style: 'margin-top: 25px',
				boxLabel:getCommonTranslation('PUBLISH_TIMESHEET_PAYROOL'),
				inputValue: true,
				uncheckedValue: false,
				checked:true,
			}]},{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 256,
					labelAlign:'top'
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getUserModuleTranslation('EMPLOYEE_TYPE'),
					store : 'user.EmployeeTypeStore',
					valueField: 'id',
					displayField: 'value',  
					name: 'employeeType',
					itemId:'employeeTypeId',
					//allowBlank: false,
					editable: false,
					//hidden:true
				},{
					xtype: 'nestedJsonCombo',
					fieldLabel: getUserModuleTranslation('EMPLOYMENT_TYPE'),
					store : 'common.FacultyTypeCSMStore',
					valueField: 'id',
					displayField: 'value',  
					name: 'facultyTypeCSM',
					itemId:'facultyTypeId',
					//allowBlank: false,
					editable: false,
					//hidden:true
				}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_1'),
				name:'externalSysRefOne',
				itemId : 'externalSysRefOne',
				maxLength : 50,
				hidden:true
			},{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_2'),
				name:'externalSysRefTwo',
				itemId : 'externalSysRefTwo',
                maxLength : 50,
				hidden:true
				
			},{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_3'),
				name:'externalSysRefThree',
				itemId : 'externalSysRefThree',
				
				valueField: 'id',
				maxLength : 50,
				hidden:true
			
			}]}]	
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			style:{
				'border-top': '1px solid var(--border-color-disabled) !important'
			},
			
		items: [{
		xtype:'fieldset',
		width: '100%',
		collapsible:true,
		//collapsed: true,
		title:getCommonTranslation('OTHER_DETAILS'),
		//style:{marginLeft:'0px',marginRight:'0px',marginTop:'0px'}, 
		defaults : {
			labelAlign:'top',
			padding: 2,
			width: 256,
			tdAttrs: { style: 'padding: 5px;'}
		},
		/*layout:{
			type:'table',
			columns:3		
		},*/
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top',
				enforceMaxLength : true	
			},
			items: [{
			xtype:'nestedJsonCombo',
			overrideSetValue:false,
			fieldLabel:getCommonTranslation('SUB_DEPARTMENT'),
			name:'subDepartment',
			itemId : 'subDepartmentId',	
			store: 'department.ChildDepartmentStore',
			valueField: 'id',
			displayField: 'name',
			editable: false,
			disabled:true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('BLOOD_GROUP'),

			name: 'bloodGroup',
			store: 'enquiry.studentDetail.BloodGroupStore',
			valueField: 'id',
			displayField: 'value',
			editable: false
		},{
			/**
			 *  Changes for bug 0010296 in mantis
			 */
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("INTERNAL_EXTERNAL"),
			name:'whetherInternal',
			itemId:'whetherInternalId',
			store: 'common.InternalExternal',
			valueField: 'id',
			displayField: 'name',
			editable: false,
			value:true	
		
			}]},
		 {
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
			xtype: 'nestedJsonCombo',
			fieldLabel: getPersonModuleTranslation('RELIGION'),
			store: 'common.ReligionStore',
			itemId: 'religionCombo',
			valueField: 'id',
			displayField: 'value',
			name: 'religion',
			editable:false
		},{
			xtype: 'nestedJsonCombo',
			fieldLabel: getPersonModuleTranslation('NATIONALITY'),
			itemId: 'nationalityCombo',
			store: 'common.NationalityStore',
			valueField: 'id',
			displayField: 'value',
			name: 'nationality',
			editable:false
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME'),
			name: 'beneficiaryName'
		  }
		]},
		 {
			  xtype: 'fieldcontainer',
			  width:'100%',
			  layout: {
					type: 'hbox'
				},
				defaults :{
					width: 256,
					labelAlign:'top'
				},
				items: [{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('ACCOUNT_NUMBER'),
			name: 'accountNumber'
		},{
			xtype: 'customcombobox',
			fieldLabel: getPersonModuleTranslation('ACCOUNT_TYPE'),
			name: 'accountTypeId',
			valueField: 'id',
			displayField: 'value',
			store: 'user.AccountTypeStore',
			editable: false,
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('BANK_NAME'),
			name: 'bankName'
		}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('BRANCH_NAME'),
			name: 'branchName'
		},{
			xtype: 'textfield',
			fieldLabel: getPersonModuleTranslation('IFSC_CODE'),
			name: 'ifsCode',
			maxLength : 11
		},{
            xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
            name: 'joiningDate',
            itemId :'dateOfJoining',
            disabled:true,
           //minValue: new Date(),
            vtype: 'daterange',
            endDateField: 'dateOfExit',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items: [{
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT'),
				name: 'dateOfExit',
				itemId :'dateOfExit',
//				disabled:true,
				hidden:true,
				vtype: 'daterange',
				startDateField: 'dateOfJoining',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
			}]

		}]},
	  ]}, {
		xtype:'fieldcontainer',
		cls:'form-fixed-footer',
		items:[{
			xtype:'button',
			text:getCommonTranslation('SAVE'),
			itemId:'submitBtn',
			formBind : true,
			action:'save',
			//align:'right',
			ui:'CustomBtnSubmit',
			scale:CONSTANTS.BUTTONSIZE,
			style:{
				'margin-left':'16px !important'
			}
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function() {
				var form = this.up('form');
				form.getForm().reset();
				var baseController = Academia.app.getController('Academia.controller.base.BaseController');
				var countryFieldCodeArray = ["#mobileCountryCode"];
				baseController.setDefaultCountryCode(form, countryFieldCodeArray)
			}
		}]
	}]
});