	/**
 * @author Pritam.Patil
 * approval Details Panel 
 */
Ext.define('Academia.view.servicerequest.common.ApprovalDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.approvaldetailspanel',
    title: getServiceRequestTranslation('APPROVAL_DETAILS'),
    standardSubmit: false,
    collapsible: true,
    cls: 'zero-left-padding-header-panel',
    plugins : "formlabelrequired",
    frame : true,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
            	type: 'hbox'
            },
            items: [{
                xtype: 'displayfield',
                fieldLabel: getServiceRequestTranslation('USER_NAME'),
                itemId:'user',
                name: 'assigneeId',
                width: 400,
                labelWidth:73,
                cls: 'zero-top-margin-displayfield'
            }]
            },{
        xtype: 'fieldcontainer',
        layout: {
        	type: 'hbox'
        },
        defaults :{
        	labelAlign: 'top'
        		},
        items: [{
    		xtype : 'textfield',
    		fieldLabel : getCommonTranslation('SCHOLARSHIP_NAME'),
    		name : 'scholarshipName',
    		itemId : 'scholarshipName',
    		width: 256,
    		hidden : true,
    		readOnly : true
        },{
        	xtype: 'numberfield',
        	fieldLabel: getServiceRequestTranslation('AMOUNT'),
    		hidden : true,
        	itemId: 'amount',
        	width: 256,
        	name: 'scholarshipAmount',
            disabled: true,
            readOnly: true,
            allowBlank:false
        }]
        },{
            xtype: 'fieldcontainer',
            layout: {
            	type: 'hbox'
            },
            defaults :{
            	labelAlign: 'top'
            		},
            items: [{
            	 xtype: 'datefield',
                 fieldLabel: getServiceRequestTranslation('SCHOLARSHIP_AWARD_DATE'),
                 name: 'awardDate',
             	 width: 256,
             	//--submitFormat: CONSTANTS.DATE_FORMAT,
                 itemId: 'scholarshipAwardDate',
                 listeners: {
                	 render: function(field) {
                		 return dateFormatRender(field);
                	 }
                 },
                 hidden: true,
                 readOnly: true,
                 disabled: true,
                 allowBlank:false
            },{
            	 xtype: 'datefield',
                 fieldLabel: getServiceRequestTranslation('SCHOLARSHIP_VALID_FROM'),
                 name: 'validFrom',
             	 width: 256,
             	//--submitFormat: CONSTANTS.DATE_FORMAT,
                 itemId: 'scholarshipValidFrom',
                 listeners: {
                	 render: function(field) {
                		 return dateFormatRender(field);
                	 }
                 },
                 hidden: true,
                 disabled: true,
                 readOnly: true,
                 allowBlank:false
            },{
            	
            	 xtype: 'datefield',
                 fieldLabel: getServiceRequestTranslation('SCHOLARSHIP_VALID_UPTO'),
                 name: 'validUpto',
             	 width: 256,
             	//--submitFormat: CONSTANTS.DATE_FORMAT,
                 itemId: 'scholarshipValidUpto',
                 listeners: {
                	 render: function(field) {
                		 return dateFormatRender(field);
                	 }
                 },
                 hidden: true,
                 disabled: true,
                 readOnly: true,
                 allowBlank:false
            }]
            },{
            xtype: 'fieldcontainer',
            layout: {
            	type: 'hbox'
            },
        items:[{
            xtype: 'textareafield',
            name: 'remarks',
            width: 600,
            maxLength : 255,
            enforceMaxLength : true,
            itemId:'approvalRemarks',
            labelAlign: 'top',
            fieldLabel: getServiceRequestTranslation('APPROVAL_REMARKS'),
            allowBlank:false
        },
			{
				xtype: 'checkboxfield',
				width: 'auto',
				labelAlign: 'right',
				style: { 'margin-top': '27px' },
				name: 'isLeaveOverride',
				itemId: 'isLeaveOverride',
				boxLabel: getCommonTranslation('OVERRIDE_ATTENDANCE'),
				hidden: true,
				readOnly: true,
				allowBlank:true
		}]
          },{
            xtype: 'fieldcontainer',
            itemId:'approvalButtonsContainer',
            layout: {
            	type: 'hbox'
            },
        items:[{
        	xtype: 'button',
        	name : 'APPROVED',
	        text: getServiceRequestTranslation('APPROVE'),
	        itemId: 'approveBtn',
	        formBind:true,
	        ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE
        },{
        	xtype: 'button',
	        text: getServiceRequestTranslation('REJECT'),
	        name : 'REJECTED',
	        itemId: 'rejectBtn',
	        formBind:true,
	        ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
	        style: {
	        	margin: '0 10px !important;'
	        }
        },{
        	xtype: 'button',
        	name : 'ESCALATED',
	        text: getServiceRequestTranslation('ESCALATE'),
	        itemId: 'escalateBtn',
	        ui: 'CustomBtnSubmit',
	        scale: CONSTANTS.BUTTONSIZE,
			style: {
				margin: '0 10px !important;'
			}
        }]
          },{
        	xtype: 'fieldcontainer',
            items:[{
            	xtype: 'approvaldetailsgrid',
            	itemId: 'approvaldetailsgridId',
            	cls: 'zero-left-margin-grid',
            	isFixHeightGrid: true,
            	tbar: []
            }]
        }]
});
