/**
 * @author pritam.patil
 *  Execution Details Panel 
 */
Ext.define('Academia.view.servicerequest.common.ExecutionDetailsPanel', {
	extend: 'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.executiondetailspanel',
	title: getServiceRequestTranslation('EXECUTION_DETAILS'),
	collapsible: true,
	plugins : "formlabelrequired",
	autoScroll: false,
    cls: 'zero-left-padding-header',
	items: [{
		xtype:'hidden',
		name:'requestType',
		itemId:'requestType'	
	},{
		xtype: 'fieldcontainer',
		defaults: {
			//width: 235,
			labelAlign: 'top'
		},
		items: [{
			xtype: 'displayfield',
			itemId: 'user',
			fieldLabel:getServiceRequestTranslation('USER_NAME'),
			name: 'userId',
			noEllipses: true
		},{
			xtype: 'fieldcontainer',
			layout: {
				type: 'hbox'
			},
			defaults: {
				width: 235,
				labelAlign: 'top'
			},
			items: [{
				xtype: 'datefield',
				fieldLabel: getServiceRequestTranslation('REQUEST_EXECUTED_ON'),
				name: 'executionDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				itemId: 'executionDateId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
				 //Select from time
			},{
				xtype: 'datefield',
				fieldLabel: getServiceRequestTranslation('ADMISSION_DATE'),
				name: 'admissionDate',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				itemId: 'admissionDateId',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
				 //Select from time
			}]
		}, {
	    	xtype: 'fieldcontainer',
	    	width : '100%',
	    	layout: {
	    		type: 'hbox'
	    	},
	    	defaults: {
	    		width: 235,
				labelAlign: 'top'
	    	},
	    	items: [{
				xtype: 'customcombobox',
				fieldLabel: getServiceRequestTranslation('CLOSURE_REASON'),
				name: 'closureReasonId',
				store: 'servicerequest.common.ClosureReasons',
				valueField: 'id',
				displayField: 'value',
				allowBlank: false,
				editable: false,
				width: 235,
				// querymode : 'local'
			}, {
  			    xtype:'checkbox',
			    name: 'isCalculateSeparateCGPAndSGPA',
			    boxLabel: getExaminationTranslation('CALCULATE_SEPARATE_CGPA_AND_SGPA_FOR_THE_PROGRAM'),
			    itemId:'isCalculateSeparateCGPAndSGPAId',
			    inputValue: true,
				uncheckedValue: false,
				//disabled:true,
    			margin: '27 0 0 0'
		      }, {

					xtype: 'multiselectcombofield',
					name: 'readmissionOutcomeIds',
					itemId: 'readmissionOutcomeIds',
					fieldLabel:getServiceRequestTranslation('READMISSION_OUTCOME'),
					store:'servicerequest.feerequest.ReadmissionOutcomeStore',
					valueField: 'id',
					width: 260,
					displayField: 'value',
					queryParam:'readmissionOutcome',
					allowBlank: false,
					hidden:true,
					disabled:true,
					typeAhead:true,
					triggerAction: 'all',
					minChars:3,			
					emptyText: getCommonTranslation('ENTER_THREE_CHAR')	,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.maxWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
				}]
		    }]
	    }, {
				xtype: 'textareafield',
				name: 'remark',
				labelAlign: 'top',
				maxLength: 10000000,
				enforceMaxLength:true,
				fieldLabel: getServiceRequestTranslation('CLOSURE_RREMARKS'),
				width: 500
	},{
    	xtype: 'fieldcontainer',
    	width : '100%',
    	layout: {
    		type: 'hbox'
    	},
    	defaults: {
    		width: 235
    	},
    	items: [{
    		xtype: 'customcheckboxfield',
    		boxLabel:getServiceRequestTranslation('DO_YOU_WANT_TO_RETAIN_THE_DATA'),
    		name:'isRetainData',
    		itemId:'isRetainDataItemId',
    		//allowBlank: false,
			inputValue : true,
			uncheckedValue: false,
			hidden:true
    	}]
    },{
		xtype: 'fieldcontainer',
		itemId:'executionfieldcontaineritemId',
		items:[]
	},{
    	xtype:'fieldcontainer',
    	cls: 'form-fixed-footer',
    	width:'auto',
    	layout: {
    		type: 'hbox'
    	},
        items: [{
        	xtype: 'button',
    		text: getServiceRequestTranslation('SUBMIT'),
    		ui: 'CustomBtnSubmit',
    		itemId: 'executionSubmitBtn',
    		scale: CONSTANTS.BUTTONSIZE,
    		hidden:true,
    		formBind: true
    		}]
	}]
});