/**
 * @author pritam.patil
 * This is used for complain details Form
 */
Ext.define('Academia.view.servicerequest.complaintrequest.ComplaintDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.complaintdetailsform',
    frame: false,
    border: false,
    autoScroll: true,
    margin: 10,
    plugins: "formlabelrequired",
    
    cls:'x-form-fixed-footer-parent horizontalScrollingFixed',
    items: [{
    	xtype:'panel',
    	items:[{
		xtype:'hidden',			
    	name:'id',
    	itemId:'id',
    },{
       	xtype:'hidden',			
      	name:'version'
  	},{
		xtype:'nestedJsonCombo',
		name:'complaintTypeSetting',
		itemId:'settingId',
		hidden:true
	},{
        xtype: 'displayfield',
        hideLabel:true,
        itemId: 'pendingDaysMessageField',
        name: 'pendingDaysMessage',
        hidden : true
    },{
        xtype: 'form',
        title: getServiceRequestTranslation('GRIEVANCE_DETAILS'),
        collapsed: false,
        frame:true,
        margin: 0,
        cls: 'zero-left-padding-header',
        bodyStyle: {
        	padding: '0px ! important;'
        },
        items: [{
        	xtype: 'fieldcontainer',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            layout: 'hbox',
            items: [{
                    xtype: 'displayfield',
                    itemId: 'enteredBy',
                    fieldLabel: getServiceRequestTranslation('ENTERED_BY'),
                    name: 'enteredBy'
            	}]
        },{
        xtype: 'fieldcontainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
            store: 'servicerequest.complaintrequest.ComplaintTypes',
            valueField: 'id',
            name : 'complaintTypeId',
            itemId: 'complaintTypeId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_DATE'),
            name: 'requestDate',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'complainDateId',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            allowBlank: false,
            maxValue: new Date()
          }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [ {
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_AGAINST'),
            store: 'servicerequest.complaintrequest.ComplaintAgainsts',
            name : 'against',
            valueField: 'id',
            itemId: 'complaintAgainstId',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
            xtype: 'livesearchcombo',
            labelAlign: 'top',
            displayField: 'value', 
        	valueField: 'id', 
            name: 'complaintAgainstPerson',
            fieldLabel: getServiceRequestTranslation('SELECT_PERSON'),
            store: 'Academia.store.servicerequest.complaintrequest.ComplaintPersons',
            itemId: 'selectPersonId',
            allowBlank: false,
            disabled : true,
            displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["value"]]}' +
             		'</tpl>'
             		)
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId : 'complaintByFieldContainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('GRIEVANCE_BY'),
            store: 'servicerequest.complaintrequest.ComplaintBy',
            name : 'complaintBy',
            valueField: 'id',
            itemId: 'complaintById',
            displayField: 'value',
            allowBlank: false,
            editable: false
        },{
                xtype: 'livesearchcombo',
                labelAlign: 'top',
                name: 'complainant',
                displayField: 'value', 
            	valueField: 'id', 
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_NAME'),
                store: 'Academia.store.servicerequest.complaintrequest.Complaintant',
                itemId: 'selectComplaintantId',
                allowBlank: false,
                disabled : true,
                displayTpl: new Ext.XTemplate(
                 		'<tpl for="."between=" ">',
                 		'{[typeof values === "string" ? values : values["value"]]}' +
                 		'</tpl>'
                 		)
        }]},{
            xtype: 'fieldcontainer',
         
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            //layout: 'vbox',
            style:{
            	'margin-bottom':'20px !important'
            },
            items: [{
            	xtype: 'customcombobox',
            	name: 'internalResourceId',
            	itemId: 'facilityCodeId',
            	fieldLabel: getServiceRequestTranslation('FACILITY_CODE'),
            	store: 'servicerequest.complaintrequest.FacilityCodes',
            	valueField: 'id',
            	displayField: 'valueCode',
            	queryParam:'name',
            	minChars:3,
            	typeAhead:false,
            	hideTrigger:false,
            	forceSelection:true,
            	//triggerAction: '',
            	triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	//allowBlank:false,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{value}' +
            			'</div>';
            		}
            	}
            },{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('FACILITY_DESCRIPTION'),
                name: 'facilityDescription',
                width : 400,
                maxLength : 255,
                //allowBlank: false,
                itemId: 'facilityDescriptionId'
            },{
                xtype: 'textareafield',
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_REMARKS'),
                name: 'remarks',
                width : 400,
                maxLength : 255,
                enforceMaxLength : true,
                itemId: 'complaintRemarksId',
                allowBlank: false,
                style:{
                	'margin-bottom':'40px !important'
                },
            }]
        },{
        xtype: 'fieldcontainer',
        width: '100%',
        cls:'form-fixed-footer',
        items: [{
            xtype: 'button',
            itemId: 'btnSaveComplaint',
            text: getCommonTranslation('SUBMIT'), 
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CLEAR_SEARCH'),
            ui:'CustomBtnCancel',
            itemId: 'cancelIdComplaint',
            style:{
            	marginLeft:'10px'
            },
            handler : function(){
            	this.up('form').getForm().reset();
            },
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]}]
});