/**
 * @author Pritam.Patil
 * Change Of Exam Center Form of exam request type 
 */
Ext.define('Academia.view.servicerequest.examrelatedrequest.examrequesttype.ChangeOfExamCenterForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.changeofexamcenterform',
    autoScroll : true,
    items: [{
        xtype: 'commonfieldsform',
        itemId : 'centerCommonForm',
        margin : 0
	},{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('CURRENT_EXAM_BATCH'),
            name: 'currentBatch',
            allowBlank: false,
            itemId: 'currentBatchId'
        },{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('CURRENT_EXAM_CENTER'),
            name: 'currentCenter',
            allowBlank: false,
            itemId :'currentExamCenterId'
         },{
        	 xtype : 'nestedJsonCombo',
        	 name : 'currentExamBatch',
        	 itemId : 'hidden_batchId',
        	 hidden : true
         },{
        	 xtype : 'nestedJsonCombo',
        	 name : 'currentExamCenter',
        	 itemId : 'hidden_centerId',
        	 hidden : true
         }]
    },{
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
        	 xtype: 'customcombobox',
             fieldLabel: getServiceRequestTranslation('SELECT_EXPECTED_DATE'),
             name: 'expectedDate',
             itemId: 'expectedDateId',
             store: 'servicerequest.examrelatedrequest.ExpectedExamDates',
             valueField: 'id',
             displayField: 'value',
             allowBlank: false,
             editable: false,
             queryMode: 'local'
        },{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('SELECT_EXPECTED_EXAM_CENTER'),
            name: 'expectedExamCentreId',
            itemId : 'expectedCenterId',
            store: 'servicerequest.examrelatedrequest.ExpectedExamCenters',
            valueField: 'id',
            displayField: 'code',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }]
    },{
    	 xtype: 'fieldcontainer',
         layout: {
             type: 'vbox'
         },
         defaults: {
             labelAlign: 'top'
         },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('SELECT_EXAM_CENTER_TYPE'),
            name: 'centerType',
            itemId : 'centerTypeId',
            store: 'servicerequest.examrelatedrequest.CenterTypes',
            valueField: 'id',
            displayField: 'value',
            allowBlank: false,
            width: 256,
            editable: false,
            queryMode: 'local'
        },{
        	xtype : 'textareafield',
        	fieldLabel: getServiceRequestTranslation('WHY_CHANGE_OF_CENTER'),
            name: 'changeOfExamCenterReason',
            itemId: 'changeOfExamCenter'  ,
            width: 536,
            maxLength : 255,
            enforceMaxLength : true,
            allowBlank: false
        }]
        }]
});