/**
 * Revaluation Details Grid 
 */
Ext.define('Academia.view.servicerequest.examrelatedrequest.examrequesttype.RevaluationGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.revaluationgrid',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    selModel:Ext.create('Ext.selection.CheckboxModel',{
    	singleSelect: true,
    	showHeaderCheckbox : false,
    	itemId : 'selModelId'
    }),
    columns: [{
        header: getServiceRequestTranslation('QUESTION_NO'),
        dataIndex: 'questionNo',
        sortable: true,
        flex: .2
    },{
        header: getServiceRequestTranslation('QUESTION_NO_PART'),
        dataIndex: 'questionNoPart',
        sortable: true,
        flex: .2
    }, {
        header: getServiceRequestTranslation('QUESTION_NO_PART_1'),
        dataIndex: 'questionNoPart1',
        sortable: true,
        flex: .2
    },  {
        header: getServiceRequestTranslation('REVALUATION_REMARKS'),
        dataIndex: 'revalautionMark',
        sortable: true,
        flex: .2
    }],
    initComponent: function() {
       var this$ = this;
       var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
   buildStore: function() {
        return Ext.create('Academia.store.servicerequest.examrelatedrequest.Questions');
    }

});