/**
 * @author pritam.patil
 * Free From Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.facultyservicerequest.FreeFormRequestDetailsPanel', {
    extend: 'Ext.form.Panel',
	//extend: 'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.freeformrequestdetailspanel',
    frame: false,
    border: false,
    plugins : "formlabelrequired",
    cls: 'x-form-fixed-footer-parent',
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        itemId: 'requestorId',
        name: 'requester',
        hidden: true
    }, {        
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'                
        },
        items: [{
            xtype: 'requesterdetailspanel',
            itemId: 'requesterDetails',
            margin: 0
        }]        
}, {
        xtype: 'fieldset',
        title: getServiceRequestTranslation('BASIC_DETAILS'),
        collapsed: false,
        items: [{
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'enterdById',
                fieldLabel: getServiceRequestTranslation('ENTERED_BY'),
                name: 'enteredBy',
                width:300
            }, {
                xtype: 'displayfield',
                itemId: 'requestAssignedId',
                fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
                name: 'requestAssignedTo',
                width:300
            },{
            	xtype: 'displayfield',
            	itemId: 'instructionsRaiseItemId',
            	width:592,
            	fieldLabel: getServiceRequestTranslation('INSTRUCTIONS'),
            	name: 'instructions'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'datefield',
                fieldLabel: getServiceRequestTranslation('REQUEST_DATE'),
                name: 'requestDate',
              //--submitFormat: CONSTANTS.DATE_FORMAT,
                itemId: 'RequestDate',
                allowBlank: false,
                listeners: {
                	render: function(field) {
                		field = dateFormatRender(field);						
        				field.setValue(new Date());
                		//return dateFormatRender(field);
                	}
                }
            }, {
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('REQUEST_BY'),
                
                name: 'requesterType',
                store: 'servicerequest.common.RequestBy',
                valueField: 'value',
                displayField: 'name',
                allowBlank: false,
                editable: false,
                querymode: 'local'
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: {
                type: 'hbox'
            },
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('REQUEST_CATEGORY'),
                name: 'freeFormRequestCategoryId',
                itemId: 'freeFormRequestType',
                store: 'servicerequest.servicerequestsettings.FreeFormCategories',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                editable: false
            }, {
                xtype: 'customcombobox',
                fieldLabel: getServiceRequestTranslation('REQUEST_TYPE'),
                name: 'freeFormRequestTypeId',
                itemId: 'subRequestType',
                store: 'servicerequest.servicerequestsettings.SubRequestTypes',
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                editable: false,
                disabled: true
            },{
                xtype: 'customcombobox',
                //height: 50,
                fieldLabel: getServiceRequestTranslation('REQUEST_SUB_TYPE'),
                name: 'freeFormRequestSubTypeId',
                itemId: 'freeFormRequestSubTypeId',
                allowBlank: false,
                editable: false
            },{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('OFFERED_MODULE'),
                name: 'offeredModule',
                itemId: 'offeredModuleId',
                store: 'servicerequest.studentservicerequest.EnrolledOrOfferedCoursesStore',
                valueField: 'id',
                displayField: 'value',
                allowBlank: true,
                editable: false,
                hidden:true
            }]
        },{
        	xtype : 'fieldcontainer',
        	itemId:'sportDetailView',
        	layout: 'anchor',
        	hidden:true,
        	items:[{
        		xtype : 'fieldcontainer',
        		layout : 'hbox',
        		defaults: {
        			width: 226,
        			labelAlign: 'top'
        		},
        		items : [{
        			xtype: 'customcombobox',
        			name: 'sportsType',
        			itemId: 'sportsType',
        			fieldLabel: getServiceRequestTranslation('SPORTS_TYPE'),
        			valueField: 'id',
        			disabled:true,
        			displayField: 'value',
        			allowBlank: true,
        			editable: false,
        			listeners: {
        				render: function(combo) {
        					var store = Ext.create('Academia.store.servicerequest.studentservicerequest.StudentSportTypeStore');
        					combo.bindStore(store);
        				}
        			}

        		},{
        			xtype: 'textfield',
        			width: 226,
        			maxLength : 45,
        			enforceMaxLength : true,
        			labelAlign: 'top',
					allowBlank: true,
					disabled:true,
        			fieldLabel: getServiceRequestTranslation('POSITION_PLAYED'),
        			name: 'positionPlayed',
        			itemId: 'positionPlayed'
        		},{
        			xtype: 'button',
        			itemId: 'addMoreSport',
        			cls: 'CustomBodyBtnSettings',
        			text: getCommonTranslation('ADDBUTTONTEXT'),
        			tooltip: getCommonTranslation('ADD'),
        			style:{
        				marginTop:'30px'
        			}
        		}]
        	}]},{
			xtype: 'customcombobox',
			name: 'tshirtSize',
			itemId: 'tshirtSize',
			hidden:true,
			labelAlign: 'top',
			width:226,
			fieldLabel: getServiceRequestTranslation('TSHIRT_SIZE'),
			 valueField: 'id',
             displayField: 'value',
             allowBlank: true,
             disabled:true,
             editable: false,
             store:'servicerequest.studentservicerequest.StudentTshirtSizeStore'
			
		},{
        	xtype: 'numberfield',
            fieldLabel: getServiceRequestTranslation('AMOUNT'),
            labelAlign: 'top',
            width: 225,
            name: 'minimumAmount',
            itemId: 'amountItemId',
            hideTrigger: true,
			keyNavEnabled: false,
			mouseWheelEnabled: false,
			allowExponential:false,
        },{
            xtype: 'textareafield',
            width: 458,
            maxLength : 255,
            enforceMaxLength : true,
            labelAlign: 'top',
            fieldLabel: getServiceRequestTranslation('REQUEST_DETAILS'),
            name: 'remarks',
            itemId: 'remarksId'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        margin: '16 0 0 10',
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'freeFormSubmitBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE,
            style: {
            	'margin-left': '10px !important;'
            }
        }]
    }]
});