/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.servicerequest.feeservicerequest.ApproverFeeRequestDetailGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.approverfeerequestdetailgrid',
	store : 'feeandpayment.feerequest.ApproverFeeRequestDetails',
	border: true,
	cls:'horizontal-scrolling-fix', 
	style:{overflow:'hidden !important',margin:'0!important'}, 
	autoScroll: true,
	style :{
    	marginLeft : '16px'
    },
	plugins: [{
		ptype: 'rowexpander',
		expandOnDblClick : false,
		pluginId: 'feeRealtedRequestRowExpander',
		rowBodyTpl: new Ext.XTemplate('<td colspan="5"><table style="border:1px solid black;">', 
				'<tr>', 
				'<th  style="width:200px;border-bottom:1px solid black;background-color: #f2f2f2">' + getFeeAndPaymentCommonTranslation('INSTALLMENT_DUE_DATE') + '</th>',
				'<th  style="width:100px;border-bottom:1px solid black;background-color: #f2f2f2">' + getFeeAndPaymentCommonTranslation('AMOUNT') + '</th>', 
				'</tr>',
				'<tpl for=".">',
				'<tr>', 
				'<td style="width:200px;text-align:center">{[dateRender(values.installmentDueDate)]}</td>',
				'<td style="width:100px;text-align:center">{amount}</td>', 
				'</tr>', 
				'</tpl>',
		'</table></td>')
	}],
	border: true,    
	viewConfig: {
		getRowClass: function (record, rowIndex, rowParams, store) {
			var installmentDetail = record.get('installmentDetails');
            if (installmentDetail.length==0) {
              	return 'hide-row-expander';
            }
    	},
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getFeeAndPaymentCommonTranslation('FEE_REQUEST_AGAINST'), //Applicant Name
		dataIndex: 'feeRequestAgainst',
		flex: 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			if(value=='PENDING_BILLS'){
				return getCommonTranslation('PENDING_BILLS');
			}
			else if(value=='FUTURE_BILLING'){
				return getCommonTranslation('FUTURE_BILLING');
			}
		}
	},{
		header: getFeeAndPaymentCommonTranslation('CATEGORY'), //Academic Term
		dataIndex: 'category',
		flex: 1,
		renderer:function(value, metaData, record, rowIndex, colIndex, view){
			if(value=='INSTALLMENT'){
				return getCommonTranslation('INSTALLMENT');
			}
			else if(value=='FEE_CONCESSION'){
				return getCommonTranslation('FEE_CONCESSION');
			}
		}
	},{
		header: getFeeAndPaymentCommonTranslation('REQUEST_DATE'), //Application ID
		dataIndex: 'requestDate',
		flex: 1,
		renderer:function(value){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}	
	},{
		header: getFeeAndPaymentCommonTranslation('FEE_HEAD_NAME'), 
		dataIndex: 'feeHeadName',
		flex: 1
	},{
		header: getFeeAndPaymentCommonTranslation('WAIVER_AMOUNT_REQUESTED'), 
		dataIndex: 'waiverAmountRequested',
		flex: 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			} 
		}

	},{
		header: getFeeAndPaymentCommonTranslation('REMARK'), 
		dataIndex: 'remark',
		flex: 1
	},{
		header: getFeeAndPaymentCommonTranslation('BILLABLE_AMOUNT'),
		dataIndex: 'billableAmount',
		flex: 1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			} 
		}
	}],

	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		items: [{
			xtype: 'custompagingtoolbar',
			plugins: ['pagesize'],
			displayInfo: true,
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			store: 'feeandpayment.feerequest.ApproverFeeRequestDetails'
		}]
	}]
});
