/**
 *  @author Rajkumar.patidar
 */

Ext.define('Academia.view.servicerequest.feeservicerequest.FeeRelatedServiceRequestInstallmentGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feerelatedservicerequestinstallmentgrid',
	store : 'feeandpayment.feerequest.FeeRelatedServiceRequestInstallment',
	border: true,
	cls:'horizontal-scrolling-fix', 
	style:{overflow:'hidden !important',margin:'0!important'}, 
	autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		emptyText: getCommonTranslation('EMPTY_MESSAGE'),
		deferEmptyText: false
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		text:getFeeAndPaymentCommonTranslation('APPROVE'),
		tooltip : getCommonTranslation('ADD'),
		glyph : ICONGLYPH.ADDGLYPH
	}],

	columns: [{
		dataIndex : 'checkBoxStatus',
		xtype: 'checkcolumn',
	    flex: 0.1,
	    align: 'left',
	    disabled : true,
	    disabledCls : 'x-item-enabled',
	    hideable: false,
	    columnHeaderCheckbox: true
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_DUE_DATE'),
		dataIndex : 'installmentDueDate',
		flex : 1,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('INSTALLMENT_AMOUNT'),
		dataIndex : 'amount',
		flex : 1
	}]
});