/**
 *  @author Rajkumar.patidar
 */

 var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {	
      clicksToEdit: 1,
      listeners : {
    	beforeedit:function( editor, context, e ){ 
        }
    }
 });
 
Ext.define('Academia.view.servicerequest.feeservicerequest.FeeRequestService', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feerequestservice',
	store : 'servicerequest.feerequest.FeeServiceRequest',
	border: true,
	autoScroll: true,
	selType:'checkboxmodel',
	selModel: {
		 showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false
   },
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
				header : getFeeAndPaymentCommonTranslation('BILL_NO'),
				dataIndex : 'billNo',
				flex : 1
	        },{
				header : getFeeAndPaymentCommonTranslation('FEE_HEAD'),
				dataIndex : 'feeHeadName',
				flex : 1
	        },{
	        	header : getFeeAndPaymentCommonTranslation('DISCOUNT_TYPE')+' <span class="required" style="color:red"> *</span>',
				dataIndex : 'discountType',
				flex : 1,
				editor : {
					xtype: 'customcombobox',
					name: 'discountType',
					itemId:'discountType',
					store: 'feeandpayment.DiscountType',
					valueField: 'id',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true
				},
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						if(value == getFeeAndPaymentCommonTranslation('PERCENTAGE')){
							return getCommonTranslation('PERCENTAGE');
						}
						else if(value == getFeeAndPaymentCommonTranslation('FIXED_AMOUNT')){
							return getCommonTranslation('FIXED_AMOUNT');
						}
						else if(value == getFeeAndPaymentCommonTranslation('ADHOC')){
							return getCommonTranslation('ADHOC');
						}
					} else {
						meta.tdCls = 'gridInputCustomStyle'; 
						return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
					}                        
				} 
	        },{
	        	header : getFeeAndPaymentCommonTranslation('DISCOUNT_CODE')+' <span class="required" style="color:red"> *</span>',
				dataIndex : 'discountCode',
				flex : 1,
				editor : {
					xtype: 'customcombobox',
					name: 'discountCode',
					itemId:'discountCode',
					store: 'feeandpayment.DiscountCode',
					valueField: 'value',
					displayField: 'value',
					typeAhead:true,
					forceSelection:true,
					listeners :{ 
						select : function(obj,record){
							var discountCodeId = record[0].get("id");
							var feeRequestModel = obj.ownerCt.grid.getSelectionModel().getSelection()[0];				
							feeRequestModel.set("discountCodeId",discountCodeId);
						}
					}
				 },
				 renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return value;
					} else {
						meta.tdCls = 'gridInputCustomStyle'; 
						return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
					}                        
				}
			},{
				header : getFeeAndPaymentCommonTranslation('AMOUNT_WAIVER_REQUESTED'),
				dataIndex : 'waiverAmountRequested',
				flex : 1,
				hidden:true
			},{
				header : getFeeAndPaymentCommonTranslation('AMOUNT_WAIVER_APPROVED'),
				dataIndex : 'waiverAmountApproved',
				flex : 1,
				hidden:true,
				editor : {
					xtype:'numberfield',
					name: 'waiverAmountApproved',
					itemId:'waiverAmountApproved',
					mouseWheelEnabled:false,
					//allowBlank:false,
					allowDecimals:true,
					hideTrigger:true,
					minValue:0
				},
				renderer:function(value,meta){
					if(!isNullOrEmpty(value)) {
						return value;
					} else {
						meta.tdCls = 'gridInputCustomStyle'; 
						return getFeeAndPaymentCommonTranslation('CLICK_TO_ENTER');
					}                        
				}
			},{
				header : getFeeAndPaymentCommonTranslation('INSTALLMENT_REQUEST'),
				dataIndex : 'installmentRequest',
				flex : 1,
				hidden:true,
				renderer:function(value){
					return  '<a href="#">Approve</a>';
				}
			/*},{
				header : getFeeAndPaymentCommonTranslation('DISCOUNT_CODE'),
				dataIndex : 'discountCode',
				flex : 1,
				hidden:true,
				editor : {
					    xtype:'customcombobox',
						name: 'discountCode',
					    itemId:'waiverAmountApproved',
					    mouseWheelEnabled:false,
						allowDecimals:true,
						hideTrigger:true,
						minValue:0
					  }
			},{
				header : getFeeAndPaymentCommonTranslation('REMARK'),
				dataIndex : 'remark',
				flex : 1,
				editor : {
				    xtype:'textarea',
					name: 'remark',
				    itemId:'remark',
				    height:40
				  }*/
			}],
	       plugins: [cellEditing]
});