/**
 *  @author Pankaj Sisodiya
 */
Ext.define('Academia.view.servicerequest.feeservicerequest.SelectReasonReAddmissionForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectReasonReAddmissionForm',
    cls:'boxShadowReaddmission',
    items:[{
    	xtype: 'fieldset',
    	border:1,
    	cls:'selectReasonCls',
    	margin:0,
    	items: [{
    		xtype: 'fieldcontainer',
    		width: '100%',
    		layout: {
    			type: 'hbox'
    		},
    		items: [{
    			flex:1,
    			cls:'htmlClsLabel',
    			html: getServiceRequestTranslation('SELECT_CONTRIBUTED_UNDERACHIEVEMENT')
    		},{
    			xtype: 'button',
    			itemId: 'addSectionBtn',
    			iconCls:'icon-addbutton',
    			cls:'addbutton addBtnReAdmission'
    		},{
    			html: getServiceRequestTranslation('ADD_MORE_REASON'),
    			width:120,
    			itemId:'addLabel',
    			cls:'htmlClsLabel',
    			margin:'10 0 0 5'
    		},{
    			xtype: 'button',
    			itemId: 'deleteSectionBtn',
    			cls: 'CustomBodyBtnReject',
				glyph: ICONGLYPH.DELETEGLYPH,
    			hidden:true,
    			margin:'3 0 0 5'
    		},{
    			margin:'10 0 0 5',
    			cls:'htmlClsLabel',
    			itemId:'deleteLabel',
    			hidden:true,
    			width:120,
    			html: getServiceRequestTranslation('DELETE_REASON')
    		}]


    	},{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('REASON'),
            name: 'serviceReason',
            itemId: 'serviceReason',
            store: 'servicerequest.feerequest.ReasonServiceRequestStore',
            valueField: 'id',
            displayField: 'itemValue', 
            allowBlank: false,
            labelAlign:'top',
            
            matchFieldWidth :true,
            width: 256,
            editable: false,
            querymode: 'local'
    	},{
    		xtype: 'textareafield',
    		emptyText: getServiceRequestTranslation('TYPE_MOTIVATION_REASON_HERE'),
    		name: 'motivationReason',
    		itemId: 'motivationReason',
    		enforceMaxLength : true,
    		maxLength : 3000,
    		maxWord:350,
    		width:'100%',
    		height:100,
    		cls: 'reasonTextArea',
    		maxLengthText : getServiceRequestTranslation('MAX_LENGTH_VALIDATION'),
    		listeners: {
    			afterrender: function(field) {

    				/*if(Ext.ComponentQuery.query('#motivationReason').length > 1){
    					field.maxWord=150;
    				}*/
    				// Create counter element right below textarea
    				field.charCountEl = Ext.DomHelper.append(field.el, {
    					tag: 'div',
    					cls: 'maxCharacterCls',
    					style: 'display:block;',
    					html: getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + '0 / ' + field.maxLength
    				}, true);

    				field.wordCountEl = Ext.DomHelper.append(field.el, {
    					tag: 'div',
    					cls: 'maxCharacterCls',
    					style: 'display:block;',
    					html: getCommonTranslation('MAX_WORD_LIMIT')+ ' - ' + '0 / ' + field.maxWord
    				}, true);

    				// Update count on input
    				field.on('change', function() {
    					var val = field.getValue() || '';
    					var maxWords =field.maxWord;
    					 var words = field.getValue().trim().length > 0 ? field.getValue().trim().split(/\s+/) : [];
    					 var wordCount = words.length;
    					 val = val.substring(0, field.maxLength);
 						 field.setValue(val);
    					 if (wordCount >= maxWords+1) {
    			                value = words.slice(0, maxWords).join(' ');
    			                field.setValue(value);
    			                showWarningMessage(getPersonModuleTranslation('ALERT'), getCommonTranslation('EXCEEDED_THE_ALLOWED_WORD'));
    			                field.wordCountEl.setHTML(getCommonTranslation('MAX_WORD_LIMIT')+ ' - ' + maxWords + ' / ' + field.maxWord);
    			                field.fireEvent('change');
    			            }else{
    			            	field.wordCountEl.setHTML(getCommonTranslation('MAX_WORD_LIMIT')+ ' - ' + wordCount + ' / ' + field.maxWord);
    			            }
    					 if(val.length > field.maxLength){
    						 showWarningMessage(getPersonModuleTranslation('ALERT'), getCommonTranslation('EXCEEDED_THE_ALLOWED_COUNT'));
    					 }
    					field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH')+ ' - ' + val.length + ' / ' + field.maxLength);
    					//sanitizeValue();	
    				});

    				var sanitizeValue = function () {
    					var val = field.getValue() || '';
    					var words = val.trim().length ? val.trim().split(/\s+/) : [];

    					// Enforce max words strictly
    					if (words.length > field.maxWord) {
    						val = words.slice(0, field.maxWord).join(" ");
    						field.setValue(val);
    						//showWarningMessage(getPersonModuleTranslation('ALERT'), getCommonTranslation('EXCEEDED_THE_ALLOWED_WORD'));
    					}

    					// Enforce max characters strictly
    					if (val.length > field.maxLength) {
    						/*val = val.substring(0, field.maxLength);
    						field.setValue(val);*/
    						//showWarningMessage(getPersonModuleTranslation('ALERT'), getCommonTranslation('EXCEEDED_THE_ALLOWED_COUNT'));
    					}

    					// Re-evaluate after corrections
    					words = val.trim().length ? val.trim().split(/\s+/) : [];

    					// Update HTML counters
    					field.charCountEl.setHTML(getExaminationTranslation('MAX_CHARACTER_LENGTH') + ' - ' + val.length + ' / ' + field.maxLength);
    					field.wordCountEl.setHTML(getCommonTranslation('MAX_WORD_LIMIT') + ' - ' + words.length + ' / ' + field.maxWord);
    				};

    				
    				/*field.inputEl.on('input', function () {
    					sanitizeValue();
    				});*/

    				
    				field.inputEl.on('paste', function () {
    					Ext.defer(function () {
    						sanitizeValue();
    					}, 10);
    				});
    			}
    		}
    	}]
    }]
});