/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.servicerequest.infirmary.manageintervention.ManageInterventionAddEditForm',{
	extend:'Academia.view.common.IdGeneratorForm',
	alias : 'widget.manageinterventionaddeditform',
	modal: true,		
    autoScroll:true,		
    bodyPadding: '10 10 10 10',
    action:"",
    frame:true,		
    plugins:"formlabelrequired",
    standardSubmit: false,
    layout: {		
        type: 'vbox'		
    },		
    defaults: {		
        labelAlign: 'top',		
       // autoScroll:true		
    },		
    style:{		
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM		
    },
	plugins : "formlabelrequired",
	itemId:'manageInterventionAddEditFormItemId',
	cls:'x-form-fixed-footer-parent',
	items : [{
		xtype:'hidden',
		name:'id',
		valueField: 'id',
		itemId:'infirmaryDetailId'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('DATE'),
			maxValue:new Date(),
			name : 'infirmaryDate',
            allowBlank: false,
			itemId : 'infirmaryDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
			vtype : 'daterange'
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
            allowBlank: false,
//			translationKey : 'ACADEMY_LOCATION',
			name: 'academyLocationId',
			itemId:'academyLocationId',
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			width: 256,
			queryParam:'qry',
			typeAhead : true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			forceSelection:true,
			hideTrigger:false,
			queryMode: 'remote',
			triggerAction: '',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'doctorUserId',
			itemId:'doctorUserId',
			store: Ext.create('Academia.store.servicerequest.infirmary.manageintervention.UsersByCounselorRoleStore'),
			fieldLabel: getServiceRequestTranslation('COUNSELOR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
            allowBlank: false,
			queryParam:'qry',
			/*triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',*/
			queryMode: 'remote',
			width: 256,
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: '',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'userGroupId',
            allowBlank: false,
			itemId:'userGroupId',
			editable:false,
			store: Ext.create('Academia.store.userGroup.AllUserTypeStore'),
			fieldLabel: getCommonTranslation('USER_TYPE'),
			width: 256,
			valueField: 'id',
			displayField: 'userGroupName'
		},{
			xtype: 'customcombobox',
			name: 'departmentId',
			itemId: 'departmentId',
			fieldLabel: getCommonTranslation('DEPT_NAME'),
			store: Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore'),
			displayField:'value',
            valueField:'id',
			hidden: true,
			editable:false
		},{		
			xtype: 'customcombobox',	               
			name: 'userId',
			itemId:'user_studentname_infirmarycombo',
			fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
			displayField: 'valueCode',
			valueField: 'id',
            allowBlank: false,
			disabled:true,
			queryParam:'term',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryMode: 'remote',
			typeAhead:true,
			triggerAction: '',
			forceSelection:true,
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.StudentsByAcademyLocationIdStore');
					combo.bindStore(store);
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			//emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}'  +
				'</div>';
			}
		},{		
			xtype: 'customcombobox',	               
			name: 'userId',
			itemId:'user_employeename_infirmarycombo',
			fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
			store:'user.UsersByDepartmentANdAlStore',
			displayField: 'valueCode',
			valueField: 'id',
			disabled:true,
            allowBlank: false,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryMode: 'remote',
			//typeAhead:true,
			forceSelection:true,
			queryParam:'qry',
			triggerAction: '',
			hidden:true,
			minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		},{
        	xtype: 'customcombobox',
            name: 'infirmaryReasonId',
            itemId:'infirmaryReasonId',
            fieldLabel: getServiceRequestTranslation('INTERVENTION_REASON'),
            store:'servicerequest.infirmary.manageintervention.InterventionReasonStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
			editable:false
            //allowBlank: false
        }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('PROGRAM'),
//			translationKey : 'PROGRAM',
            name: 'programId',
            itemId:'programId',
            store: 'feeandpayment.ProgramSmartSearchStore',
            displayField: 'value',
            valueField: 'id',
            width: 256,
            //typeAhead : true,
            forceSelection:true,
            hideTrigger:false,
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryMode: 'remote',
			queryParam:'programName',
			triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
        },{
			 xtype: 'customcombobox',
			 name: 'batchId',
			 itemId:'batchId',
			 //store: 'program.programbatchdetail.BatchByProgramIdSSStore',
			 fieldLabel: getCommonTranslation('BATCH'),
			 valueField: 'id',
			 displayField: 'value',
			 queryParam:'qry',
			 disabled:true,
			 //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			 enableKeyEvents  : 'true',
			 queryMode: 'remote',
			 minChars:3,
			 editable:true,
			 //typeAhead:true,
			 enableKeyEvents  : 'true',
			 hideTrigger:false,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 triggerAction: 'all',
			 forceSelection:true,
			 allowBlank:true,
			 listeners: {
					render: function(combo) {
						var store = Ext.create('Academia.store.program.programbatchdetail.BatchByProgramIdSSStore');
						combo.bindStore(store);
					}
				}
		 	}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PERIOD'),
            name: 'periodId',
            itemId:'periodId',
            //store: 'program.programbatchdetail.PeriodByBatchIdSSStore',
            displayField: 'value',
            valueField: 'id',
            width: 256,
            //typeAhead : true,
            queryParam:'qry',
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryMode: 'remote',
            disabled:true,
            forceSelection:true,
            hideTrigger:false,
			triggerAction: 'all',
            minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
            	render: function(combo) {
            		var store = Ext.create('Academia.store.program.programbatchdetail.PeriodByBatchIdSSStore');
            		combo.bindStore(store);
            	}
            }
        },{
			 xtype: 'customcombobox',
			// store: 'program.programbatchdetail.SectionByPeriodIDSmartSearch',
			 fieldLabel: getCommonTranslation('SECTION'),
			 valueField: 'sectionId',
			 displayField: 'sectionCode',
			 name: 'sectionId',
			 itemId:'sectionId',
			 disabled:true,
			 queryParam:'qry',
			 minChars:3,
			 editable:true,
			 //typeAhead:true,
			 //triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			 enableKeyEvents  : 'true',
			 queryMode: 'remote',
			 enableKeyEvents  : 'true',
			 hideTrigger:false,
			 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			 triggerAction: 'all',
			 forceSelection:true,
			 allowBlank:true,
			 listeners: {
	            	render: function(combo) {
	            		var store = Ext.create('Academia.store.program.programbatchdetail.SectionByPeriodIDSmartSearch');
	            		combo.bindStore(store);
	            	}
	            }
		 	}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
            xtype: 'checkbox',
            labelWidth: 200,
            name: 'whetherAuthorityInformed',
            itemId: 'whetherAuthorityInformed',
            boxLabel: getServiceRequestTranslation('WHETHER_INFORMED_F_A'),
            inputValue: true,
            uncheckedValue:false,
            checked:false,
            listeners: {
                change : function( checkBox, newValue, oldValue, eOpts ) {
                	var field=this.nextSibling();
                	field.allowBlank = !newValue;
                	if(newValue) {
                		var allowblankFalse = '<span class="required" style="color:red"> *</span>';
                		field.labelSeparator = '';
                		field.setFieldLabel(getServiceRequestTranslation('WHETHER_INFORMED_F_A')+allowblankFalse);
                	} else {
                		field.setFieldLabel(getServiceRequestTranslation('WHETHER_INFORMED_F_A'));
                	}
                	field.setDisabled(!newValue);
                	field.reset();
                	field.validate();
                }
            }
        },{
			xtype: 'customcombobox',	               
			name: 'authorityUserId',
			itemId:'authorityUserId',
			fieldLabel: getCommonTranslation('USER_CODE_OR_NAME'),
			store:'common.ActiveUserStore',
			displayField: 'valueCode',
			valueField: 'id',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			queryMode: 'remote',
			typeAhead:true,
			triggerAction: '',
			forceSelection:true,
			minChars:3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'  +
	                    '</div>';
	                }
	            }
		
		}]
	},{
		/*xtpe:'panel',
		layout : {
			type : 'hbox'
		},
		width: '100%',
		margin:'0 0 0 -10',
		items:[{
			xtype: 'panel',
			width : '100%',
			flex:1,
			items:[{*/
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width: 256,
					labelAlign : 'top'
				},
								items : [
										{
											xtype : 'checkbox',
											labelWidth : 200,
											name : 'whetherParentInformed',
											itemId : 'whetherParentInformed',
											boxLabel : getServiceRequestTranslation('WHETHER_INFORMED_PARENT'),
											inputValue : true,
											uncheckedValue : false,
											checked : false,
											listeners : {
												change : function(checkBox,
														newValue, oldValue,
														eOpts) {
													try {
														var field = this
																.nextSibling();
														var remarkField = this
																.up('form')
																.down('#remark');
														field.allowBlank = !newValue;
														if (newValue) {
															var allowblankFalse = '<span class="required" style="color:red"> *</span>';
															field.labelSeparator = '';
															field
																	.setFieldLabel(getServiceRequestTranslation('PARENT_GURDIAN_NAME')
																			+ allowblankFalse);
														} else {
															field
																	.setFieldLabel(getServiceRequestTranslation('PARENT_GURDIAN_NAME'));
														}
														remarkField
																.setDisabled(!newValue);
														field
																.setDisabled(!newValue);
														remarkField.reset();
														remarkField.validate();
														field.reset();
														field.validate();
													} catch (e) {
														Ext.getBody().unmask();
														console.log(e);
													}
												}
											}
										},
										    {
											xtype : 'multiselectcombofield',
											name : 'parentUserId',
											fieldLabel : getServiceRequestTranslation('PARENT_GURDIAN_NAME'),
											store : 'personinfo.student.ParentInfoByPersonStore',
											displayField : 'value',
											valueField : 'id',
											itemId : 'parentUserId',
											width: 256,
											minChars : 3,
											typeAhead : true,
											triggerCls : Ext.baseCSSPrefix
													+ 'x-form-trigger',
											enableKeyEvents : 'true',
											hideTrigger : false,
											forceSelection : true,
											disabled : true,
											cls : 'multiBrandCampusCls',
											listConfig : {
												listeners : {
													beforeshow : function(
															picker) {
														picker.minWidth = picker
																.up('combobox')
																.getSize().width;
													}
												},
												loadingText : getCommonTranslation('SEARCHING'),
												emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
												getInnerTpl : function() {
													return '<div class="search-item">'
															+ '{value}'
															+ '</div>';
												}
											}

										}
				]
			},{
				xtype : 'fieldcontainer',
				width : '100%',
				layout : {
					type : 'hbox'
				},
				defaults : {
					width: 536,
					labelAlign : 'top'
				},
				items : [{
					xtype : 'textarea',
					labelAlign : 'top',
					//height: 110,
					maxLength:250,
					name:'remark',
					itemId:'remark',
					disabled:true,
					fieldLabel : getServiceRequestTranslation('REMARK')
				}]
			},{
				xtype:'fieldcontainer',
				layout: 'hbox',
				width : '100%',
				defaults: {
					width: 256,
					labelAlign: 'top'
				},
				items:[{
	                    xtype: 'timefield',
	                    name: 'timeIn',
	                    itemId: 'timeIn',
	                    fieldLabel: getCommonTranslation('TIME_FROM'), //Time From
	                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT,
	                    increment: 30,
	                    vtype: 'timerange',
	                    endTimeField: 'timeOut'
	                }, {
	                    xtype: 'timefield',
	                    name: 'timeOut',
	                    itemId: 'timeOut',
	                    fieldLabel: getCommonTranslation('TIME_TO'), //Time To
	                    submitFormat: CONSTANTS.DISPLAY_TIME_FORMAT, //Select to time
	                    increment: 30,
	                    vtype: 'timerange',
	                    startTimeField: 'timeIn'
	                }]
			//}]
		//}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
        	xtype: 'customcombobox',
            name: 'infirmaryOutcomeId',
            itemId:'infirmaryOutcomeItemId',
            fieldLabel: getCommonTranslation('INFIRMARY_INTERVENTION_OUTCOME'),
            store:'servicerequest.infirmary.manageintervention.InterventionOutcomeStore',
            displayField:'value',
            valueField:'id',
            forceSelection:true,
            editable: false
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype:'displayfield',
			value:'<b class="menu-title">'+getServiceRequestTranslation('FD_UPLOAD_DOCUMENT')+'</b>',
			style: {
				textDecoration: "underline"
			}
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype:'infirmarydetaildocumentgrid',
			itemId : 'infirmarydetaildocumentgridInterventionItemId',
			minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			isFixHeightGrid: true,
			isFixWidthColums: true,
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'100%',
		items : [{
			xtype: 'manageinterventionaddentrygrid',
	        flex:1,
			style: {
	            marginLeft: '0px'
	        }
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		cls:'form-fixed-footer',
		items : [ {
			xtype : 'button',
			text : getPlacementTranslation('SAVE'),
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			text : getPlacementTranslation('RESET'),
			ui : 'CustomBtnCancel',
			name : 'resetBtnForm',
			itemId : 'resetBtnForm',
			scale : CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text:getCommonTranslation('UPLOAD_DOC'),
			itemId: 'documentUploadItemId',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}]
	}]
});
