/**
 * @author : Ms.Pritam Patil 
 * This is used to show contact details form of service request (personal data change Request )
 */
Ext.define('Academia.view.servicerequest.personaldatachangerequest.datatobechanged.ContactDetailsForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.contactdetailsform',
    frame: false,
    autoScroll: true,
    items: [ {
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items :[{
        	 xtype: 'checkbox',
             boxLabel:getServiceRequestTranslation('EMPLOYEE'),
             allowBlank: false,
             inputValue : 'true',
             uncheckedValue : 'false',
             name : 'employeeOfOrganization'
        }]},
        {
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('EMPLOYEE_ID'),
            name: 'employeeId',
            itemId: 'EmployeeId',
            labelAlign: 'top',
            width: 256
        },
        {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('FIRST_NAME'),
            name: 'firstName',
            itemId: 'FirstNameId'
        },{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('MIDDLE_NAME'),
            name: 'middleName',
            itemId: 'MiddleNameId'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [ {
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('LAST_NAME'),
            name: 'lastName',
            itemId: 'LastNameId'
        },{
            xtype: 'datefield',
            fieldLabel: getServiceRequestTranslation('DATE_OF_BIRTH'),
            name: 'birthDate',
            itemId: 'birthDateId',
            allowBlank: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('GENDER'),
            
            name: 'gender',
            valueField: 'id',
            displayField: 'value',
            store: 'enquiry.studentDetail.GenderStore',
            editable: false,
            allowBlank: false
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('BLOOD_GROUP'),
            
            name: 'bloodGroup',
            valueField: 'id',
            displayField: 'value',
            store: 'enquiry.studentDetail.BloodGroupStore',
            editable: false,
            allowBlank: false
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('MARITAL_STATUS'),
            
            name: 'maritalStatus',
            valueField: 'id',
            displayField: 'value',
            store: 'common.MaritalStatusStore',
            editable: false,
            allowBlank: false
        },{
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('OCCUPATION'),
            name: 'occupation',
            itemId: 'occupationId'
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'numberfield',
            fieldLabel: getServiceRequestTranslation('PERSONAL_INCOME'),
            name: 'personalIncome',
            itemId: 'PersonalIncomeId',
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false
        },{
            xtype: 'filefield',
            
            fieldLabel: getServiceRequestTranslation('PHOTO'),
            itemId: 'photoFile',
            buttonText: 'UPLOAD',
            name: 'photoUrl'
        }]
	}, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        layout: {
            type: 'hbox'
        },
        items: [{
	    	xtype: 'fieldcontainer',
		    width: 'auto',
	    	fieldLabel: getServiceRequestTranslation('MOBILE_NO'),
	    	defaults: {
			enforceMaxLength : true,
			labelAlign: 'top',
			width: 256
	    	},
			layout : {
				type : 'hbox'
			},
		items : [ {
			xtype : 'customcombobox',
			name : 'cellCountryCode',
			itemId : 'cellCountryCode',
			emptyText : getServiceRequestTranslation('COUNTRY_CODE'),	
			valueField : 'isdCode',
			displayField : 'isdCode',
			store:'common.CountryStore',
			queryMode: 'local',
			triggerAction : 'all',
			editable : false,
			width: 108
		}, {
			xtype : 'numberfield',
			name : 'cellNo',
			emptyText : getServiceRequestTranslation('MOBILE_NO'),
			maxLength: 10,
			minLength:10,
			// To Remove spinner buttons, and arrow key and mouse wheel listeners
	        hideTrigger: true,
	        keyNavEnabled: false,
	        mouseWheelEnabled: false
		}]}]
    },{
		xtype : 'textfield',
		fieldLabel : getServiceRequestTranslation('EMAIL_ID'),
		name : 'primaryeEmailId',
		emptyText : getServiceRequestTranslation('EMAIL_ID'),
		vtype: 'email',
		allowBlank: false,
		enforceMaxLength : true,
		labelAlign: 'top',
		width: 256
	} ,{
        xtype: 'splitter'
    }, {
        xtype: 'label',
        forId: 'addressId',
        text: getServiceRequestTranslation('ADDRESS_DETAILS'),
        style: 'text-decoration:underline'
    }, {
        xtype: 'fieldcontainer',
        plugins: "formlabelrequired",
        width: 'auto',
        items:[{
        xtype: 'addressfieldsform',
        itemId: 'addressfieldsformItemId'
    }]}, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('SUBMIT'),
            itemId: 'personDetailsSubmitButtonId',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'personDetailsCancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});