/**
 * @author : Ms.Pritam Patil 
 * This is used to show previous Education details form of service request (personal data change Request )
 */
Ext.define('Academia.view.servicerequest.personaldatachangerequest.datatobechanged.EducationDetailsForm', {
	extend: 'Ext.form.Panel',
    alias: 'widget.educationdetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        itemId: 'education_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'nestedJsonCombo',
            itemId: 'examPassed',
            fieldLabel: getPersonModuleTranslation('EXAM_PASSED'),
            store: 'common.ExamPassedStore',
            valueField: 'id',
            displayField: 'value',
            name: 'examPassed',
            editable : false,
            readOnly : true,
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        items: [{
            xtype: 'hidden',
            itemId: 'subjectMarkInfoId',
            name: 'subjectMarkInfoId'
        }, {
            xtype: 'hidden',
            itemId: 'subjectMarkVersion',
            name: 'subjectMarkVersion'
        }, {
            xtype: 'customcombobox',
            itemId: 'subject',
            fieldLabel: getPersonModuleTranslation('SUBJECT'),
            store: 'common.SubjectTypeStore',
            labelAlign: 'top',
            width: 256,
            valueField: 'id',
            displayField: 'value',
            name: 'subject',
            allowBlank: false,
            editable : false
        }, {
            xtype: 'textfield',
            itemId: 'marks',
            fieldLabel: getPersonModuleTranslation('MARKS_GRADE'),
            labelAlign: 'top',
            width: 256,
            name: 'marks',
            maxLength:3,
            allowBlank: false,
            disabled: true,
            validator: function(value){
            	var validText = getPersonModuleTranslation('MARKS_GRADE_VALID_TYPE');
            	var patt = new RegExp('(^[A-Z]{1}[+]{1}$)|(^[A-Z]{1}[+]{2}$)|(^[A-Z]{1}[-]{1}$)|(^[A-Z]{1}[-]{2}$)|(^[A-Z]{1}[0-9]{1}$)|(^[A-Z]{1}$)|(^[0-9]+$)');
            	var res = patt.test(value);
                if(res) {
                    return true;
                } else {
                    return validText;
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('RESULT'),
            
            name: 'examResult',
            allowBlank: false
        }, {
            xtype: 'numberfield',
            fieldLabel: getPersonModuleTranslation('YEAR_PASSED'),
            
            minValue: 1900,
            listeners: {
                afterrender: function(yearNumber, eOpts) {
                    var year = new Date().getFullYear();
                    yearNumber.setMaxValue(year);
                }
            },
            name: 'yearPassed',
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('EXAM_CONDUCTED_BY'),
            
            name: 'examConductedBy',
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});