/**
 * @author pritam.patil
 *  Scholarship Request Details Panel 
 */
Ext.define('Academia.view.servicerequest.scholarshiprequest.RequestDetailsPanel', {
    extend: 'Ext.form.Panel',
    alias: 'widget.requestdetailspanel',
    frame: false,
    border: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'nestedJsonCombo',
        name: 'assignee',
        itemId: 'assigneeId',
        hidden: true
    }, {
        xtype: 'nestedJsonCombo',
        name: 'serviceRequestSetting',
        itemId: 'settingId',
        hidden: true
    }, {        
        xtype: 'fieldcontainer',
        defaults: {
            labelAlign: 'top'                
        },
        items: [{
            xtype: 'requesterdetailspanel',
            itemId: 'requesterDetails',
            margin: 0
        }]        
},{
        xtype: 'basicdetails',
        style: {
            marginBottom: '-29px',
            marginLeft: '0px'
        }
    }, {
        xtype: 'fieldcontainer',
        layout: {
            type: 'hbox'
        },
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        style: {
            marginLeft: '10px',
            marginBottom: '45px'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getServiceRequestTranslation('SCHOLARSHIP_ID'),            
            name: 'scholarshipId',
            itemId:'scholarshipId',
            store: 'servicerequest.scholarshiprequest.Scholarships',
            valueField: 'id',
            displayField: 'scholarshipName',
            allowBlank: false,
            editable: false
        }, {
        	xtype: 'numberfield',
        	fieldLabel: getServiceRequestTranslation('AMOUNT'),
        	readOnly: true,
        	itemId: 'amount',
        	name: 'scholarshipAmount'
        }]
    },{
        xtype: 'fieldcontainer',
        width: '100%',
        style: {
            marginLeft: '7px'
        },
        items: [{
            xtype: 'button',
            text: getServiceRequestTranslation('UPLOAD_DOC'),
            itemId: 'scholarshipSubmitBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            scale: CONSTANTS.BUTTONSIZE,
            hidden: true
        }]
    }]
});