Ext.define('Academia.view.servicerequest.servicerequestsettings.DocumentsEditableGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.documentseditable',
	border:true,
	//store:'servicerequest.servicerequestsettings.Documents',
	store:'servicerequest.servicerequestsettings.DocumentSelector',
	requires: [
	            'Ext.selection.CellModel',
	            'Ext.grid.*'
	        ],
	        minHeight: 0,
			cls: 'no-empty-placeholder-grid',
			isFixHeightGrid: true,
			isFixWidthColums: true,
   viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS,
		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		deferEmptyText: false
	},	
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		checkOnly: true
	},
	plugins: [
		Ext.create('Ext.grid.plugin.CellEditing', {
			clicksToEdit: 1
		})
	],
	tbar: [{
		xtype: 'form',
			bodyStyle: {
			background: 'transparent'
		},
		items: [{
			xtype: 'hidden',
			itemId:'moduleId',
			name: 'module'
		},{
			xtype: 'filefield',
			allowBlank: true,
			itemId:'filefieldServiceReqSettingId',
			buttonOnly : true,
			disabled:true,
			cls:'CustomBtnCancel DocumentsEditableGridUploadCls',
			name: 'file',
			buttonText: getCommonTranslation('UPLOAD')
		}]
	}],
	columns:[{
		dataIndex:'id',
		hidden:true,
		sortable:false,
		menuDisabled: true
	},{
		header: getServiceRequestTranslation('DOCUMENT_NAME'),
		dataIndex:'value',
		renderer:function(value){
			return value;
		},
		flex:0.2,
		sortable:false,
		menuDisabled: true
	},{
		header : getServiceRequestTranslation('RULE'),//Category
		dataIndex : 'rule',	
		renderer:function(value){
			if(value !== '') {
				return value;
			} else {
				return getServiceRequestTranslation('DROOLS_AGENDA');
			}						
		},
		flex:.2,
		editor: {
			xtype: 'textfield',
			width:'100Px',
			name: 'rule',
			emptyText: getServiceRequestTranslation('DROOLS_AGENDA')//Drools Agenda		       
		},
		sortable:false,
		menuDisabled: true
	},{
		header : getServiceRequestTranslation('RULE_DESC'),//Rule Desciption
		dataIndex : 'ruleDescription',	
		renderer:function(value){
			if(value !== '') {
				return value;
			} else {
				return getServiceRequestTranslation('RULE_DESCRIPTION');
			}						
		},
		flex:.2,
		editor: {
			xtype:'textfield',
			width:'100Px',
			name:'ruleDescription',
			emptyText:getServiceRequestTranslation('RULE_DESCRIPTION')//Enter feedback
		},
		sortable:false,
		menuDisabled: true
	},{
		header: getFeeAndPaymentCommonTranslation('REFERENCE_DOCUMENTS'),
		dataIndex:'referenceDocument',
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(record.data.refDocumentId)){
				return '<a href=#>'+record.data.referenceDocument+'</a> <button class="clsReferenceDocumentRemoveBtn" type="button">Remove</button>';
			} else if(!isNullOrEmpty(record.data.referenceDocument)){
				return record.data.referenceDocument;
			} else {
				return '';
			}
		},
		flex:0.2,
		sortable:false,
		menuDisabled: true
	}]
});