/**
 * @author pritam.patil
 * This is used for Student Transfer Form
 */
Ext.define('Academia.view.servicerequest.terminations.TransferForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.transferform',
    frame: false,
    border: false,
    autoScroll: true,
    plugins: "formlabelrequired",
    items: [{
		xtype:'hidden',			
    	name:'id'
    },{
       	xtype:'hidden',			
      	name:'version'
  	},{
		xtype:'nestedJsonCombo',
		name:'assignee',
		itemId : 'assigneeId',
		hidden:true
	},{
		xtype:'nestedJsonCombo',
		name:'serviceRequestSetting',
		itemId:'settingId',
		hidden:true
	},{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'requesterdetailspanel',
            itemId: 'requesterDetails',
            margin : 0
        }]
    }, {
        xtype: 'fieldset',
        title: getServiceRequestTranslation('TRANSFER_REASON'),
        collapsed: false,
        items: [{
        xtype: 'fieldcontainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        layout: 'hbox',
        items: [{
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('PROGRAM'),
            store: 'servicerequest.programcoursesectiontransfer.FromPrograms',
            valueField: 'id',
            name : 'transferProgram',
            itemId: 'transferProgramId',
            displayField: 'value',
            allowBlank: false,
            editable: false,
            queryMode: 'local'
        }, {
            xtype: 'nestedJsonCombo',
            fieldLabel: getServiceRequestTranslation('TRANSFERING_REASON'),
            store: 'servicerequest.TransferReasons',
            name : 'transferReason',
            valueField: 'id',
            itemId: 'transferReason',
            displayField: 'value',
            allowBlank: false,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        layout: 'vbox',
        items: [{
            xtype: 'textareafield',
            name: 'remarks',
            width: 400,
            maxLength : 255,
            enforceMaxLength : true,
            fieldLabel: getServiceRequestTranslation('TRANSFERING_REMARKS'),
            allowBlank: false
        }, {
            xtype: 'livesearchcombo',
            labelAlign: 'top',
            width: 300,
            name: 'userId',
            fieldLabel: getServiceRequestTranslation('INITIATED_BY'),
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),//default assignee 
            itemId: 'user_Id',
            allowBlank: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        items: [{
            xtype: 'button',
            itemId: 'btnSaveTransfer',
            text: getServiceRequestTranslation('UPLOAD_DOC'), //Submit
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
           // formBind: true
        }, {
            xtype: 'button',
            text: getServiceRequestTranslation('WITHDRAW_REQUEST'),
            ui: 'CustomBtnSubmit',
            itemId: 'withdrawButtonId',
            hidden: true,
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
    }]
});